% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rail-lines.R
\name{rail_lines}
\alias{rail_lines}
\title{Rail Lines}
\format{
A tibble 1 row per line with 6 variables:
\describe{
\item{LineCode}{Two-letter abbreviation for the line (e.g.: RD, BL, YL, OR,
GR, or SV).}
\item{DisplayName}{Full name of line color.}
\item{StartStationCode}{Start station code. For example, will be F11
(Branch Avenue) for the Green Line, A15 (Shady Grove) for the Red Line,
etc. Use this value in other rail-related APIs to retrieve data about a
station.}
\item{EndStationCode}{End station code. For example, will be E10
(Greenbelt) for the Green Line, B11 (Glenmont) for the Red Line, etc. Use
this value in other rail-related APIs to retrieve data about a station.}
\item{InternalDestination}{Intermediate terminal station code(s). During
normal service, some trains on some lines might end their trip prior to the
\code{StartStationCode} or \code{EndStationCode.} A good example is on the Red Line
where some trains stop at A11 (Grosvenor) or B08 (Silver Spring). \code{NA} if
not defined.}
}
}
\usage{
rail_lines(api_key = wmata_key())
}
\arguments{
\item{api_key}{Subscription key which provides access to this API. Defaults
\code{Sys.getenv("WMATA_KEY")} via \code{\link[=wmata_key]{wmata_key()}}.}
}
\value{
A data frame of rail lines.
}
\description{
Returns information about all rail lines.
}
\examples{
\dontrun{
rail_lines()
}
}
\seealso{
\url{https://developer.wmata.com/docs/services/5476364f031f590f38092507/operations/5476364f031f5909e4fe330c}

Other Rail Station Information: 
\code{\link{rail_destination}()},
\code{\link{rail_entrance}()},
\code{\link{rail_path}()},
\code{\link{rail_stations}()},
\code{\link{rail_times}()},
\code{\link{station_info}()}
}
\concept{Rail Station Information}
