% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oldRegionalNull.R
\name{oldRegionalNull}
\alias{oldRegionalNull}
\title{Randomize community data matrix with regional null model}
\usage{
oldRegionalNull(picante.cdm, tree, regional.abundance)
}
\arguments{
\item{picante.cdm}{Picante-style community data matrix with
communities/plots/plots/etc as rows and species as columns}

\item{tree}{Ape-style phylogeny}

\item{regional.abundance}{Vector of species names, where each species' name is repeated
the number of times necessary to accomodate its abundance in the regional species pool.
Note that this can be created, if needed, from the observed picante.cdm with the
abundanceVector() function.}
}
\value{
A matrix with all species in the input tree in phylogenetic order, and the same
number of randomized plots as used in the input community data matrix
}
\description{
Null model that simulates community assembly where species probabilities of occurrence
are proportional to their regional abundance.
}
\details{
Although nowhere near as fast as, e.g. randomizeMatrix, this function still
runs fairly quickly (no for or while loops). It works by drawing the total number of
individuals observed in the input plot from the regional abundance vector. Thus, while
a randomized plot will not necessarily have the same number of species as the
observed plot, over many iterations it will likely be sampled. We can then
concatenate the results by richness at the end, which will only compare observed values
to random plots of the same richness. As an example, an observed plot might have
two individuals of speciesA and two of speciesB. If the regional abundance vector is
c("spA","spA","spA","spA","spB","spB","spB","spC"), and we draw four individuals, it
would be possible to draw 1, 2, or 3 species, but in general, two species would be seen
in the randomized plots.
}
\examples{
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

#prep the data for the simulation
prepped <- prepSimulations(tree, arena.length=300, mean.log.individuals=2, 
	length.parameter=5000, sd.parameter=50, max.distance=20, proportion.killed=0.2,
	competition.iterations=3)

positions <- competitionArena(prepped)

boundResults <- plotPlacer(no.plots=15, arena.length=300, plot.length=30)

#return a CDM in picante format
cdmTemp <- plotContents(positions$arena, boundResults)

test <- oldRegionalNull(cdmTemp$picante.cdm, tree, 
regional.abundance=abundanceVector(cdmTemp$picante.cdm))
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2016. Phylogenetic community
structure metrics and null models: a review with new methods and software.
Ecography DOI: 10.1111/ecog.02070
}
