% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rainforest.R
\name{rainforest}
\alias{rainforest}
\title{Rainforest plots for meta-analyses}
\usage{
rainforest(x, names = NULL, summary_name = "Summary", group = NULL,
  method = "FEM", confidence_level = 0.95, summary_symbol = "rain",
  col = "Blues", shading = TRUE, xlab = "Effect Size", text_size = 1,
  detail_level = 1)
}
\arguments{
\item{x}{data.frame or matrix with the effect sizes of all studies (e.g.,
correlations, log odds ratios, or Cohen \emph{d}) in the first column and their
respective standard errors in the second column. Alternatively, x can be the
output object of function \code{\link[metafor]{rma.uni}} from package
\pkg{metafor}.}

\item{names}{a vector with names/identifiers to annotate each study in the
rainforest plot.}

\item{summary_name}{a name to annotate the summary effect. If a subgroup
analysis is plotted, \code{summary_name} should be a vector with names for the
summary effect of each subgroup.}

\item{group}{a factor indicating the subgroup of each study. The group
argument is not necessary and ignored if \code{x} is an output object of package
\pkg{metafor}; in this case, subgroup results are used directly from the \pkg{metafor}
output object (if one categorical moderator was used).}

\item{method}{Which method should be used to compute the summary effect?
Supported methods are "FEM" for the fixed-effect model and "REM" for the
random-effects model (using the DerSimonian-Laird method to estimate the
between-study variance \eqn{\tau^2}{tau squared}). This argument is ignored if \code{x} is the output
of the function \code{\link[metafor]{rma.uni}} of package \pkg{metafor}; in this
case, meta-analytic results are used directly from the metafor output
object.}

\item{confidence_level}{the confidence level for the plotted confidence
intervals and likelihood raindrops.}

\item{summary_symbol}{which symbol should be used to depict the
meta-analytic summary effect and its confidence interval? Available
options are:
\itemize{
\item rain: A likelihood drop is used.
\item diamond:
A classic summary diamond is used.
\item none: No summary effect is displayed.
}}

\item{col}{character specifying the color palette (from package
\pkg{RColorBrewer}) used for shading. Default value is
"Blues". Other options are "Greys", "Oranges", "Greens", "Reds", and
"Purples".}

\item{shading}{logical scalar indicating if the likelihood drops should be
color shaded. Default is \code{TRUE}.}

\item{xlab}{character label of the x axis.}

\item{text_size}{numeric value. Values larger than 1 lead to larger text size,
values smaller than 1 to smaller text size than the default.}

\item{detail_level}{numeric value. Values larger than 1 lead to a higher
plotting detail (i.e., smoother likelihood raindrop polygons and more fluent
color shading), values smaller than 1 to less plotting detail compared to
the default plot.}
}
\value{
A Rainforest plot is created using ggplot2. The resulting plot is a
 ggplot2 object and is printed by default.
}
\description{
Creates a rainforest plot.
}
\details{
Rainforest plots were proposed by Schild and Voracek (2015) as a variant and
enhancement of classic forest plots. Rainforest plots use likelihood drops
to depict study and summary level results (for details, see Barrowman &
Myers, 2003). \code{rainforest} assumes normality of effect sizes to
construct these likelihood drops. Therefore, the height of a likelihood drop
for a hypothetical true value is proportional to the likelihood of that true
value given the observed estimate, while the width is identical to the
confidence interval when normality of effect sizes is assumed (which, for
example, also is the (default) case in \pkg{metafor}, Revman, and CMA). Additionaly,
color shading is utilized to further visualize statistical uncertainty, as
suggested by Jackson (2008). Finally, study and summary level point estimates
are depicted clearly by a specific symbol. Rainforest plots have the
following advantages, as compared to classic forest plots:

\enumerate{ \item The width of the likelihood raindops corresponds to the
confidence intervals, as also shown in the classic forest plot. In addition,
the height of the likelihood drops and color shading adequateley visualizes the
plausibility of true values given the observed estimate.

\item Low likelihood drops and light color shading causes small studies (with
wide confidence intervals and less weight in the meta-analysis) to be visually less
dominant.

\item In classic forest plots, it is often hard to depict the magnitude of
point estimates to a reasonable degree of accuracy, especially for studies
with large meta-analytic weights and correspondingly large plotting symbols
(commonly squares). Specific symbols within the raindrops improve the
visualization of study point estimates. }
}
\examples{
library(metaviz)
# Plotting a rainforest plot using the mozart data (for details, see help(mozart)):
rainforest(x = mozart[, c("d", "se")],
names = mozart[, "study_name"], xlab = "Cohen's d")

# Visualizing a subgroup analysis of published and unpublished studies
rainforest(x = mozart[, c("d", "se")], names = mozart[, "study_name"],
summary_name = c("Summary (published)", "Summary (unpublished)"),
group = mozart[, "unpublished"], xlab = "Cohen's d")
}
\author{
Michael Kossmeier* <michael.kossmeier@univie.ac.at>

Ulrich S. Tran* <ulrich.tran@univie.ac.at>

Martin Voracek* <martin.voracek@univie.ac.at>

*Department of Basic Psychological Research and Research Methods, School of Psychology, University of Vienna
}
\references{
Barrowman, N. J., & Myers, R. A. (2003). Raindrop plots: A new way
 to display collections of likelihoods and distributions. \emph{American
 Statistician}, \emph{57}, 268-274.

Jackson, C. H. (2008). Displaying uncertainty with shading.
 \emph{American Statistician}, \emph{62}, 340-347.

Schild, A. H., & Voracek, M. (2015). Finding your way out of the
 forest without a trail of bread crumbs: Development and evaluation of two
 novel displays of forest plots. \emph{Research Synthesis Methods}, \emph{6},
 74-86.
}

