% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box.R
\name{boxplot_data_frame}
\alias{boxplot_data_frame}
\title{Boxplot Function for Data Frame}
\usage{
boxplot_data_frame(x, yvar, xvar, facets = NULL, log = FALSE,
  horizontal = NULL, crit = 1.3, ref = NULL, nobs = FALSE,
  na.rm = TRUE, xlab = NULL, ylab = NULL, aspect = 1,
  main = getOption("metaplot_main", NULL), sub = getOption("metaplot_sub",
  NULL), ...)
}
\arguments{
\item{x}{data.frame}

\item{yvar}{y variable}

\item{xvar}{x variable}

\item{facets}{optional conditioning variables}

\item{log}{whether to log transform numeric variable (auto-selected if NULL)}

\item{horizontal}{whether box/whisker axis should be horizontal (numeric x, categorical y); defaults TRUE if (var[[2]] is numeric}

\item{crit}{if log is NULL, log-transform if mean/median ratio for non-missing x is greater than this value}

\item{ref}{optional reference line on numeric axis}

\item{nobs}{whether to include the number of observations under the category label}

\item{na.rm}{whether to remove data points with one or more missing coordinates}

\item{xlab}{passed to \code{\link[lattice]{bwplot}}}

\item{ylab}{passed to \code{\link[lattice]{bwplot}}}

\item{aspect}{passed to \code{\link[lattice]{bwplot}}}

\item{main}{character, or a function of x, yvar, xvar, facets, and log}

\item{sub}{character, or a function of x, yvar, xvar, facets, and log}

\item{...}{passed arguments}
}
\description{
Boxplot for data.frame. Uses standard evaluation.
}
\examples{
library(magrittr)
library(dplyr)
boxplot_data_frame(Theoph,'Subject','conc')
boxplot_data_frame(Theoph \%>\% filter(conc > 0),
'conc','Subject', log = TRUE, ref = c(2,5),horizontal = FALSE)
}
\seealso{
Other mixedvariate plots: \code{\link{boxplot.data.frame}}

Other boxplot: \code{\link{boxplot.data.frame}}
}
