% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrange_ggplot.R
\name{arrange_ggplot}
\alias{arrange_ggplot}
\title{Arrange separate ggplots into the same graphic}
\usage{
arrange_ggplot(
  ...,
  nrow = NULL,
  ncol = NULL,
  widths = NULL,
  heights = NULL,
  guides = NULL,
  design = NULL,
  legend.position = "bottom",
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  tag_levels = NULL,
  tag_prefix = NULL,
  tag_suffix = NULL,
  tag_sep = NULL,
  plotlist = "deprecated",
  labels = "deprecated",
  rel_widths = "deprecated",
  rel_heights = "deprecated",
  hjust = "deprecated",
  vjust = "deprecated",
  align = "deprecated"
)
}
\arguments{
\item{...}{multiple \code{ggplot}s or a list containing \code{ggplot}
objects.}

\item{nrow, ncol}{The number of rows and columns, respectively.}

\item{widths, heights}{The relative widths and heights of each column and row
in the grid. Will get repeated to match the dimensions of the grid.}

\item{guides}{A string specifying how guides should be treated in the layout.
Defaults to `'auto'`. Other possible values are `'keep'` and `'collect'`.
In this case, will collect guides below to the given nesting level,
removing duplicates.}

\item{design}{Specification of the location of areas in the layout.}

\item{legend.position}{The position of the legends in the plot if \code{guides = "collect"} Default to
`'bottom'`.}

\item{title, subtitle, caption}{Text strings to use for the various plot
annotations.}

\item{tag_levels}{A character vector defining the enumeration format to use
at each level. Possible values are `'a'` for lowercase letters, `'A'` for
uppercase letters, `'1'` for numbers, `'i'` for lowercase Roman numerals, and
`'I'` for uppercase Roman numerals. It can also be a list containing
character vectors defining arbitrary tag sequences. If any element in the
list is a scalar and one of `'a'`, `'A'`, `'1'`, `'i`, or `'I'`, this level
will be expanded to the expected sequence.}

\item{tag_prefix, tag_suffix}{Strings that should appear before or after the
tag.}

\item{tag_sep}{A separator between different tag levels.}

\item{plotlist}{Deprecated as of metan 1.11.0.}

\item{labels}{Deprecated as of metan 1.11.0. Use \code{tag_levels} instead.}

\item{rel_widths, rel_heights}{Deprecated as of metan 1.11.0. Use \code{widths
and heights} instead.}

\item{hjust, vjust}{Deprecated as of metan 1.11.0.}

\item{align}{Deprecated as of metan 1.11.0.}
}
\value{
A `patchwork` object
}
\description{
This is a wraper function around \code{\link[patchwork]{wrap_plots}()} and
\code{\link[patchwork]{plot_annotation}()} to arrange ggplot2 objects.
}
\examples{
\donttest{
library(ggplot2)
library(metan)
p1 <- ggplot(mtcars, aes(wt, mpg)) +
      geom_point()

p2 <- ggplot(mpg, aes(class, hwy)) +
             geom_boxplot()

arrange_ggplot(p1, p2)
arrange_ggplot(p1, p2,
               ncol = 1,
               tag_levels = list(c("(P1)", "(P2)")),
               title = "My grouped ggplot",
               caption = "A = scatter plot\nB = boxplot")
}

}
