% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cd.R
\name{cd}
\alias{cd}
\title{Meta-Analysis via the confidence distribution approach}
\usage{
cd(
  q1,
  med,
  q3,
  n,
  mean,
  sd,
  med.var,
  med.ci.lb,
  med.ci.ub,
  alpha.1,
  alpha.2,
  pooled.median.ci.level = 0.95,
  method = "RE",
  pool_studies = FALSE
)
}
\arguments{
\item{q1}{vector of study-specific sample first quartile values. See 'Details'.}

\item{med}{vector of study-specific sample median values. See 'Details'.}

\item{q3}{vector of study-specific sample third quartile values. See 'Details'.}

\item{n}{vector of study-specific sample sizes. See 'Details'.}

\item{mean}{vector of study-specific sample mean values. See 'Details'.}

\item{sd}{vector of study-specific sample standard deviation values. See 'Details'.}

\item{med.var}{vector of study-specific estimates of the variance of the median. See 'Details'.}

\item{med.ci.lb}{vector of study-specific lower confidence interval bounds around the medians}

\item{med.ci.ub}{vector of study-specific upper confidence interval bounds around the medians}

\item{alpha.1}{vector of the study-specific \eqn{\alpha_1} values from Ozturk and Balakrishnan (2020)}

\item{alpha.2}{vector of the study-specific \eqn{\alpha_2} values from Ozturk and Balakrishnan (2020)}

\item{pooled.median.ci.level}{optional numeric scalar indicating the desired coverage probability for the pooled median estimate. The default is \code{0.95}.}

\item{method}{character string specifying whether a fixed effect or random effects model is used. The options are \code{FE} (fixed effect) are \code{RE} (random effects). The default is \code{RE}.}

\item{pool_studies}{logical scalar specifying whether to meta-analyze the studies. If this argument is set to \code{FALSE}, function will not meta-analyze the studies and will return a list with components \code{yi} containing the study-specific effect size estimates and \code{sei} containing the study-specific within-study standard error estimates. The default is \code{TRUE}.}
}
\value{
A list with components
\item{pooled.est}{Pooled estimate of the median}
\item{pooled.est.var}{Estimated variance of the pooled median estimator}
\item{pooled.est.ci.lb}{Lower bound of confidence interval for the pooled median}
\item{pooled.est.ci.ub}{Upper bound of confidence interval for the pooled median}
\item{tausq.est}{Estimate of between-study variance (applicable only when \code{method} is set to \code{RE})}
\item{yi}{Study-specific point estimates}
\item{vi}{Study-specific sampling variances}
}
\description{
The function applies the confidence distribution (CD) approach of Ozturk and Balakrishnan (2020) to meta-analyze one-group studies where each study reports one of the following summary measures: \itemize{
\item C1 (and C2): lower and upper bounds of a confidence interval around the median, and coverage probability
\item C3: median, variance estimate of the median, and sample size
\item C4: mean, standard deviation, and sample size.
\item C5: median, first and third quartiles, and sample size
 }
The function estimates the pooled median.
}
\details{
Letting \eqn{k} denote the number of studies, provide study-specific summary data as vectors of length \eqn{k}. If a study does not report a given summary measure (e.g., the minimum value), give a value of \code{NA} for the position in the relevant vector. If no studies report a given summary measure, a vector of only \code{NA} values need not be provided. See 'Examples' for appropriate use.
}
\examples{
## Example 1:
med.vals <- c(6.1, 5.2, 3.1, 2.8, 4.5)
q1.vals <- c(2.0, 1.6, 2.6, 0.9, 3.2)
q3.vals <- c(10.2, 13.0, 8.3, 8.2, 9.9)
n.vals <- c(100, 92, 221, 81, 42)

## Meta-analyze studies via CD method
cd(q1 = q1.vals, med = med.vals, q3 = q3.vals, n = n.vals)


}
\references{
Ozturk, O. and Balakrishnan N. (2020). Meta‐analysis of quantile intervals from different studies with an application to a pulmonary tuberculosis data. \emph{Statistics in Medicine}, \strong{39}, 4519-4537.
}
