% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOA.Algorithm.R
\name{GOA}
\alias{GOA}
\title{Optimization using Grasshopper Optimisation Algorithm}
\usage{
GOA(FUN, optimType = "MIN", numVar, numPopulation = 40, maxIter = 500,
  rangeVar)
}
\arguments{
\item{FUN}{an objective function or cost function,}

\item{optimType}{a string value that represent the type of optimization.
There are two option for this arguments: \code{"MIN"} and \code{"MAX"}.
The default value is \code{"MIN"}, which the function will do minimization. 
Otherwise, you can use \code{"MAX"} for maximization problem.}

\item{numVar}{a positive integer to determine the number variable.}

\item{numPopulation}{a positive integer to determine the number population.}

\item{maxIter}{a positive integer to determine the maximum number of iteration.}

\item{rangeVar}{a matrix (\eqn{2 \times n}) containing the range of variables, 
where \eqn{n} is the number of variables, and first and second rows
are the lower bound (minimum) and upper bound (maximum) values, respectively. 
If all variable have equal upper bound, you can define \code{rangeVar} as 
matrix (\eqn{2 \times 1}).}
}
\value{
\code{Vector [v1, v2, ..., vn]} where \code{n} is number variable 
        and \code{vn} is value of \code{n-th} variable.
}
\description{
This is the internal function that implements Grasshopper 
Algorithm. It is used to solve continuous optimization tasks. 
Users do not need to call it directly,
but just use \code{\link{metaOpt}}.
}
\details{
Grasshopper Optimisation Algorithm (GOA) was proposed by Mirjalili 
in 2017. The algorithm mathematically models and mimics the 
behaviour of grasshopper swarms in nature for solving optimisation 
problems.
}
\examples{
################################## 
## Optimizing the sphere function

# define sphere function as objective function
sphere <- function(X){
    return(sum(X^2))
}

## Define parameter 
numVar <- 5
rangeVar <- matrix(c(-10,10), nrow=2)

## calculate the optimum solution using Grrasshopper Optimisation Algorithm 
resultGOA <- GOA(sphere, optimType="MIN", numVar, numPopulation=20, 
                 maxIter=100, rangeVar)

## calculate the optimum value using sphere function
optimum.value <- sphere(resultGOA)

}
\references{
Shahrzad Saremi, Seyedali Mirjalili, Andrew Lewis, Grasshopper Optimisation 
Algorithm: Theory and application, Advances in Engineering Software, 
Volume 105, March 2017, Pages 30-47, ISSN 0965-9978, 
https://doi.org/10.1016/j.advengsoft.2017.01.004
}
\seealso{
\code{\link{metaOpt}}
}
