% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/PDF_download.R
\name{PDF_download}
\alias{PDF_download}
\title{Attempts to download a PDF using a DOI link.}
\usage{
PDF_download(DOI, directory = getwd(), theFileName = "temp",
  validatePDF = TRUE, quiet = FALSE)
}
\arguments{
\item{DOI}{A string of the DOI (digital object identifier) used to identify
the source of a journal article PDF file(s).}

\item{directory}{A string of the location (directory) were downloaded PDF
files are to be saved.  Directory name must end with "\\\\".}

\item{theFileName}{Used to rename the downloaded file.  No need to include
extension ".pdf".}

\item{validatePDF}{When \code{"TRUE"} will only save to files that are valid
PDF documents.  When \code{"FALSE"} will save all candidate files, even if
they are not valid PDF formats.}

\item{quiet}{When \code{"FALSE"} does not print to console download progress
   and summary.}
}
\value{
A string describing the download success.  If unsuccessful,
   returns the type of error during the download attempt.
}
\description{
Tries to download a PDF file using the digital objected identifier (DOI) link.
Uses ad hoc searches of journal HTML pages to detect candidate PDFs for
download.  Downloads all candidate pdfs.
}
\seealso{
\code{\link{PDFs_collect}}
}

