\name{metacom-package}
\alias{metacom-package}
\alias{metacom}
\docType{package}
\title{
Pattern-based analysis of metacommunity structure}
\description{
Metacom provides functions for the analysis of the elements of metacommunity structure (coherence, boundary clumping, & turnover), following the pattern-based metacommunity framework of Leibold & Mikkelson 2002 and Presley et al. 2010. This package is designed to allow the user to distinguish between several idealized patterns of metacommunity structure (Presley et al. 2010) utilizing any number of null model algorithms for the randomization procedure.}

\details{

\tabular{ll}{
Package: \tab metacom\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2012-12-28\cr
License: \tab GPL-2 \cr
}

A metacommunity is a set of sites (e.g. plants in plant-pollinator networks) associated through interactions (e.g. insect species (columns) interact with plant species (rows) in plant-pollinator networks). The pattern-based metacommunity concept, proposed by Leibold & Mikkelson 2002 and expounded on by Presley et al. 2010, allows for the evaluation of metacommunity structure by using randomization techniques to discern between 10 patterns of metacommunity structure. This is performed by ordinating site x species interaction matrices and calculating three metrics; coherence, boundary clumping & turnover.

The metacom package calculates these three metrics; coherence is calculated using the function Coherence(), boundary clumping with BoundaryClump(), and turnover (from either species or range perspective) using the Turnover() function. These functions are consolidated in the metacommunity() function, which can be used to calculate all three metrics. In order to interpret the output of these functions, it will be helpful to read Leibold & Mikkelson 2002 and Presley et al. 2010. 

The 'metacom' package is partially adapted from previous Matlab code written by Christopher Higgins (available at http://www.tarleton.edu/Faculty/higgins/EMS.htm) and relies on many functions in the 'vegan' package (Oksanen et al. 2012)
}

\author{
Tad Dallas 

Tad Dallas <tad.dallas@drakeresearchlab.com>}

\references{

Leibold, M. & Mikkelson, G. (2002) Coherence, species turnover, and boundary clumping: elements of metacommunity structure. Oikos, 97, 237-250.

Leibold, M., Holyoak, M., Mouquet, N., Amarasekare, P., Chase, J., Hoopes, M., Holt, R., Shurin, J., Law, R., Tilman, D. et al. (2004) The metacommunity concept: a framework for multi-scale community ecology. Ecology letters, 7, 601-613.

J. Oksanen, F.G. Blanchet, R. Kindt, P. Legendre, P.R. Minchin, R.B. O'Hara, G.L. Simpson, P. Solymos, M.H.H. Stevens and H. Wagner (2012). vegan: Community Ecology Package. R package version 2.0-4. http://CRAN.R-project.org/package=vegan

Presley, S., Higgins, C. & Willig, M. (2010) A comprehensive framework for the evaluation of metacommunity structure. Oikos, 119, 908-917.

Willig, M., Presley, S., Bloch, C., Castro-Arellano, I., Cisneros, L., Higgins, C. & Klingbeil, B. (2011) Tropical metacommunities along elevational gradients: effects of forest type and other environmental factors. Oikos, 120, 1497-1508.

}



