% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\docType{class}
\name{Metabolite-class}
\alias{Metabolite-class}
\alias{Metabolite}
\title{The Metabolite class}
\value{
A Metabolite class.
}
\description{
The Metabolite object is a representation of metabolomic data, metabolomic annotation, and sample annotation.
}
\section{Slots}{

\describe{
\item{\code{assayData}}{a data.frame or data.table of metabolite measurements (peak area data or normalized data, sample [row] * feature [column]).}

\item{\code{featureData}}{a data.frame or data.table of metabolite annotation (chemical annotation)}

\item{\code{sampleData}}{a data.frame or data.table of sample annotation (sample meta data).}

\item{\code{featureID}}{a character of the metabolite ID column (in feature file and the column names of data), default: CHEM_ID (provided from Metabolon file).}

\item{\code{sampleID}}{a character of the sample ID column (in sample and the first column of data), default: PARENT_SAMPLE_NAME (provided from Metabolon file).}

\item{\code{logs}}{Log information of data analysis process.}

\item{\code{miscData}}{Ancillary data.}
}}

\seealso{
\code{\link{Metabolite}}, \code{\link{load_excel}}, \code{\link{load_data}}
}
