% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaboGSE.R
\name{metaboGSE}
\alias{metaboGSE}
\title{Gene set enrichment analysis}
\usage{
metaboGSE(
  scores,
  gene.sets = NULL,
  method = "perm",
  test = NA,
  nperm = 1000,
  nrand = 1000,
  mc.cores = 1,
  posthoc = TRUE,
  contrast = FALSE,
  prefix = NA,
  desc.data = NULL,
  cols = NULL,
  ltys = NULL
)
}
\arguments{
\item{scores}{A list of \code{scoreGeneDel} objects.}

\item{gene.sets}{A named list of gene sets for gene set enrichment analysis, or a vector of gene set IDs computed in \code{scores}. Default: NULL, all gene sets from \code{scores}.}

\item{method}{Statistical testing method \code{c("perm", "survival")}. Default: \code{"perm"}. \code{"survial"} may be used for exploration.}

\item{test}{Type of test c(\code{"likelihood", "logrank", "wald"}), when method = \code{"survival"}. Default: \code{"likelihood"}.}

\item{nperm}{Number of permutations for testing, when method = \code{"perm"}. Default: 10000.}

\item{nrand}{Number of draws for random gene set generation, when method = \code{"perm"}. Default: 1000.}

\item{mc.cores}{The number of cores to use (at least 1), i.e. at most how many child processes will be run simultaneously. Default: 1.}

\item{posthoc}{A logical value indicating if pairwise tests are performed. Default: TRUE.}

\item{contrast}{A logical value indicating if the Newick-based contrast will be computed. Default: FALSE.}

\item{prefix}{A string indicating prefix of output plots. Default: NA, no plot.}

\item{desc.data}{A vector of descriptions of a priori KEGG pathway IDs. Default: NULL,
KEGGREST will be called with internet connection required if gene.sets is KEGG pathway.}

\item{cols}{Colors for conditions. Default: rainbow colors.}

\item{ltys}{Line types for conditions. Default: incrementing line types in R.}
}
\value{
Gene set enrichment information
}
\description{
This function performs the gene set enrichment analysis.
}
\examples{
data(yarliSubmnets)
metaboGSE(yarliSubmnets[c('SH','SN')], gene.sets = "GO:0006696",
         method="perm", nperm=10, nrand=10)
}
