% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtruncnorm.R
\name{dtruncnorm}
\alias{dtruncnorm}
\alias{rtruncnorm}
\title{Truncated Normal Distribution}
\usage{
dtruncnorm(x, a = -Inf, b = Inf, mean = 0, sd = 1, log = FALSE)

rtruncnorm(n, a = -Inf, b = Inf, mean = 0, sd = 1)
}
\arguments{
\item{x}{vector of quantiles}

\item{a}{lower bound}

\item{b}{upper bound}

\item{mean}{vector of means}

\item{sd}{vector of standard deviations}

\item{log}{if TRUE, probabilities are given as log(p)}

\item{n}{number of samples}
}
\description{
Normal distribution truncated to the interval [a,b]
}
\examples{
samples <- rtruncnorm(1e5, -.5, 3, 1, 1)
hist(samples, 200, freq = FALSE)
curve(dtruncnorm(x, -.5, 3, 1, 1), -2,4,
      col = 2, lwd = 2, add = TRUE, n = 301)
}
