% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_function.R
\name{messi}
\alias{messi}
\title{Implementation of Mediation with External Summary Statistics Information (MESSI) from Boss et al. (2023).}
\usage{
messi(
  Y,
  M,
  A,
  C = NULL,
  method = "Soft EB",
  T.hat.external,
  var.T.hat.external,
  n.boot = 200,
  s2.fixed = NULL
)
}
\arguments{
\item{Y}{A (n x 1) continuous outcome vector.}

\item{M}{A (n x p_m) matrix of mediators.}

\item{A}{A (n x 1) vector of exposures.}

\item{C}{A (n x p_c) matrix of confounders and adjustment covariates. If there are no confounders or adjustment covariates set C = NULL.}

\item{method}{A string specifying which method to use. Options include 'Unconstrained', 'Hard', 'Soft EB', and 'Soft Fixed'. Default is 'Soft EB'.}

\item{T.hat.external}{External estimate of the total effect. Set to NULL if method = 'Unconstrained'.}

\item{var.T.hat.external}{Estimated variance of the external estimator of the total effect. Set to NULL if method = 'Unconstrained' or method = 'Hard'.}

\item{n.boot}{Number of parametric bootstrap draws for obtaining quantile-based confidence intervals for the TE and NDE. Relevant for method = 'Soft EB' and method = 'Soft Fixed'. Can set to NULL for method = 'Unconstrained' and method = 'Hard'.}

\item{s2.fixed}{Option to specify the tuning parameter s^2 in the soft constraint model. Only use if method = 'Soft Fixed'.}
}
\value{
A list containing the (1) point estimates and confidence intervals for the natural direct effect, the natural indirect effect, and the total effect (2) point estimates for all mediation model parameters (3) the asymptotic variance covariance matrix corresponding to alpha_a and beta_m.
}
\description{
Implementation of Mediation with External Summary Statistics Information (MESSI) from Boss et al. (2023).
}
\details{
The Soft EB method should be the default method if the user is not sure which
method to use.
}
\examples{
data(Med)

Y = Med$Y
M = Med$M
A = Med$A
C = Med$C
T.hat.external = Med$T.hat.external
var.T.hat.external = Med$var.T.hat.external

test <- messi(Y = Y, M = M, A = A, C = C, method = 'Unconstrained', T.hat.external = T.hat.external,
              var.T.hat.external = var.T.hat.external, s2.fixed = NULL)

n = Med$n
p = Med$p

plot_messi(n = n, alpha.a.hat = test$alpha.a.hat, beta.m.hat = test$beta.m.hat, 
           labels = paste0("M",1:p), asym.var.mat = test$asym.var.mat)
              
test <- messi(Y = Y, M = M, A = A, C = C, method = 'Hard', T.hat.external = T.hat.external,
              var.T.hat.external = var.T.hat.external, s2.fixed = NULL)

}
