% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnet_calc_mp.R
\name{mnet_calc_mp}
\alias{mnet_calc_mp}
\title{Calculate soil matric potential for Oklahoma Mesonet data}
\usage{
mnet_calc_mp(data)
}
\arguments{
\item{data}{a data frame that contains columns for delta-T temperature change
data (i.e. TR05, TR25, TR60, TR75)}
}
\value{
a data frame containing new columns with matric potential (kPa) for each
 column of delta-T temperature change data.
}
\description{
Calculate soil matric potential from delta-T soil temperature change data
 from the Oklahoma Mesonet using the equation from Zhang et al (2019) <doi:10.2136/sssaj2018.12.0481>: MP = 2083/(1+ exp(-3.35*(Tref-3.17)))
 where Tref is the measured delta-T data
}
\examples{

mesonet_data <- data.frame(TR05 = 3.17, TR25 = 2.17, TR60 = 2.0, TR75 = 1.0)

mnet_calc_mp(mesonet_data)

}
