% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arithmetic.r
\name{Arithmetic}
\alias{Arithmetic}
\alias{+,memuse,memuse-method}
\alias{+,memuse,numeric-method}
\alias{+,numeric,memuse-method}
\alias{+,memuse,object_size-method}
\alias{+,object_size,memuse-method}
\alias{-,memuse,memuse-method}
\alias{-,memuse,numeric-method}
\alias{-,numeric,memuse-method}
\alias{-,memuse,missing-method}
\alias{-,memuse,object_size-method}
\alias{-,object_size,memuse-method}
\alias{*,memuse,memuse-method}
\alias{*,memuse,numeric-method}
\alias{*,numeric,memuse-method}
\alias{*,memuse,object_size-method}
\alias{*,object_size,memuse-method}
\alias{/,memuse,memuse-method}
\alias{/,memuse,numeric-method}
\alias{/,numeric,memuse-method}
\alias{/,memuse,object_size-method}
\alias{/,object_size,memuse-method}
\alias{^,memuse,memuse-method}
\alias{^,memuse,numeric-method}
\title{Binary Arithmetic}
\usage{
\S4method{+}{memuse,memuse}(e1, e2)

\S4method{+}{memuse,numeric}(e1, e2)

\S4method{+}{numeric,memuse}(e1, e2)

\S4method{+}{memuse,object_size}(e1, e2)

\S4method{+}{object_size,memuse}(e1, e2)

\S4method{-}{memuse,memuse}(e1, e2)

\S4method{-}{memuse,numeric}(e1, e2)

\S4method{-}{numeric,memuse}(e1, e2)

\S4method{-}{memuse,missing}(e1, e2)

\S4method{-}{memuse,object_size}(e1, e2)

\S4method{-}{object_size,memuse}(e1, e2)

\S4method{*}{memuse,memuse}(e1, e2)

\S4method{*}{memuse,numeric}(e1, e2)

\S4method{*}{numeric,memuse}(e1, e2)

\S4method{*}{memuse,object_size}(e1, e2)

\S4method{*}{object_size,memuse}(e1, e2)

\S4method{/}{memuse,memuse}(e1, e2)

\S4method{/}{memuse,numeric}(e1, e2)

\S4method{/}{numeric,memuse}(e1, e2)

\S4method{/}{memuse,object_size}(e1, e2)

\S4method{/}{object_size,memuse}(e1, e2)

\S4method{^}{memuse,memuse}(e1, e2)

\S4method{^}{memuse,numeric}(e1, e2)
}
\arguments{
\item{e1, e2}{\code{memuse}, \code{numeric}, or \code{object_size} objects.}
}
\value{
Returns a \code{memuse} class object.
}
\description{
Binary arithmetic operations for \code{memuse} objects.
}
\details{
Simple binary arithmetic for \code{memuse} objects.  Options include any
combination of \code{memuse}, \code{object_size} (output from the
\code{object.size()} function), and \code{numeric} objects.
}
\examples{
\dontrun{
x <- mu(200)
y <- mu(100)

x+y
x-y
x*y
x/y
x^2
}

}
\seealso{
\code{ \link{Constructor}, \link{memuse-class} }
}
\keyword{Methods}
