% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum.r
\docType{methods}
\name{sum,memuse-method}
\alias{sum,memuse-method}
\title{memuse Arithmetic}
\usage{
\S4method{sum}{memuse}(x, ..., na.rm = FALSE)
}
\arguments{
\item{x}{A \code{memuse} object.}

\item{...}{Additional arguments}

\item{na.rm}{Whether \code{NA}'s should be ignored.}
}
\value{
Returns a \code{memuse} class object.
}
\description{
Binary arithmetic operations for \code{memuse} objects.
}
\details{
Simple arithmetic reductions.
}
\examples{
\dontrun{
x = mu(2000)
y = mu(5000)

sum(x, y)

### Mixing numeric and memuse objects will work, but the first one must be a
### memuse object.
sum(mu(10), 10) # This will work
sum(10, mu(10)) # This will not
}

}
\seealso{
\code{ \link{Constructor} \link{memuse-class} }
}
\keyword{Methods}
