% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispersal.R
\name{dispersal}
\alias{dispersal}
\title{Seed production, dispersal and seed bank dynamics}
\usage{
dispersal(
  sf,
  SpParams,
  local_control = medfate::defaultControl(),
  distance_step = 25,
  maximum_dispersal_distance = 3000,
  min_percent = 1,
  stochastic_resampling = FALSE,
  progress = TRUE
)
}
\arguments{
\item{sf}{An object of class \code{\link{sf}} using a UTM projection (to measure distances in m) and with the following columns:
\itemize{
\item{\code{geometry}: Spatial geometry.}
\item{\code{forest}: Objects of class \code{\link{forest}}.}
}}

\item{SpParams}{A data frame with species parameters (see \code{\link{SpParamsMED}}).}

\item{local_control}{A list of control parameters (see \code{\link{defaultControl}})}

\item{distance_step}{Distance step in meters.}

\item{maximum_dispersal_distance}{Maximum dispersal distance in meters.}

\item{min_percent}{A minimum percent of seed bank to retain entry in \code{seedBank} element of \code{forest}.}

\item{stochastic_resampling}{A flag to indicate that stochastic resampling of stands is performed.}

\item{progress}{Boolean flag to display progress information.}
}
\value{
A list with forest objects (for wildland cover type) containing a modified seed bank
}
\description{
Simulates seed bank mortality, seed production and dispersal among stands
}
\details{
The input 'sf' object has to be in a Universal Transverse Mercator (UTM) coordinate system (or any other projection using meters as length unit)
for appropriate function behavior.

Dispersal kernel follows Clark et al. (1999) and potential seed donors (neighbors) are defined up to a given grid distance order.
A maximum value of 100\% seed bank refill is attained for species with seed production in all seed donors and the local cell.
}
\examples{
\donttest{
data(example_watershed)
data(SpParamsMED)

# Transform to UTM31
example_watershed_utm31 <- sf::st_transform(example_watershed, crs = 32631)

# Estimate seed production and dispersal over the watershed
seedbank_list <- dispersal(example_watershed_utm31, SpParamsMED)

seedbank_list[[1]]

# Transform to UTM31
example_ifn_utm31 <- sf::st_transform(example_ifn, crs = 32631)

# Estimate seed production and dispersal over the set of forest inventory plots
seedbank_list <- dispersal(example_ifn_utm31, SpParamsMED)

seedbank_list[[1]]
}
}
\references{
Clark et al. (1999). Seed dispersal near and far: Patterns across temperate and tropical forests. Ecology 80(5):1475-1494
}
\seealso{
\code{\link{fordyn_land}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF.

Roberto Molowny-Horas, CREAF.
}
