% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_topography.R
\name{add_topography}
\alias{add_topography}
\alias{add_land_cover}
\alias{check_topography}
\alias{check_land_cover}
\title{Add topography and land cover}
\usage{
add_topography(x, dem, progress = TRUE)

add_land_cover(
  x,
  land_cover_map,
  wildland = NULL,
  agriculture = NULL,
  rock = NULL,
  artificial = NULL,
  water = NULL,
  progress = TRUE
)

check_topography(x, filter_missing = FALSE)

check_land_cover(x, filter_missing = FALSE)
}
\arguments{
\item{x}{An object of class \code{\link{sf}}}

\item{dem}{A digital elevation model (class \code{\link{SpatRaster}}) with meters as units}

\item{progress}{A logical flag to print console output}

\item{land_cover_map}{An object of class \code{\link{SpatRaster}} of land cover type. If missing, all locations are considered 'wildland'.}

\item{wildland, agriculture, rock, artificial, water}{Strings indicating the mapping from the legend of land_cover_map.}

\item{filter_missing}{Boolean flag to filter locations with missing data}
}
\value{
Function \code{add_topography()} returns a modified object of class \code{\link{sf}} with columns:
\itemize{
\item{\code{id}: Numeric location identifiers (if not existing).}
\item{\code{elevation}: Elevation above sea level (in m).}
\item{\code{slope}: Slope (in degrees).}
\item{\code{aspect}: Aspect (in degrees).}
\item{\code{land_cover_type}: Land cover type.}
}
Function \code{add_land_cover()} returns a modified object of class \code{\link{sf}} with new column:
\itemize{
\item{\code{id}: Numeric location identifiers (if not existing).}
\item{\code{land_cover_type}: Land cover type.}
}
}
\description{
Initializes topography and land cover type for a set of target locations
}
\details{
The user should manually define the mapping of land cover classes in \code{land_cover_map} to the land cover types
used in medfateland.
}
\examples{
# See package vignettes 'Preparing inputs'
}
\seealso{
\code{\link[=impute_forests]{impute_forests()}}, \code{\link[=add_soilgrids]{add_soilgrids()}}
}
