% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggthemes.R
\name{md_theme_base}
\alias{md_theme_base}
\alias{md_theme_calc}
\alias{md_theme_clean}
\alias{md_theme_economist}
\alias{md_theme_economist_white}
\alias{md_theme_excel}
\alias{md_theme_excel_new}
\alias{md_theme_few}
\alias{md_theme_fivethirtyeight}
\alias{md_theme_foundation}
\alias{md_theme_gdocs}
\alias{md_theme_hc}
\alias{md_theme_igray}
\alias{md_theme_map_gg}
\alias{md_theme_pander}
\alias{md_theme_par}
\alias{md_theme_solarized}
\alias{md_theme_solarized_2}
\alias{md_theme_solid}
\alias{md_theme_stata}
\alias{md_theme_tufte}
\alias{md_theme_wsj}
\title{ggthemes Markdown Themes}
\usage{
md_theme_base(...)

md_theme_calc(...)

md_theme_clean(...)

md_theme_economist(...)

md_theme_economist_white(...)

md_theme_excel(...)

md_theme_excel_new(...)

md_theme_few(...)

md_theme_fivethirtyeight(...)

md_theme_foundation(...)

md_theme_gdocs(...)

md_theme_hc(...)

md_theme_igray(...)

md_theme_map_gg(...)

md_theme_pander(...)

md_theme_par(...)

md_theme_solarized(...)

md_theme_solarized_2(...)

md_theme_solid(...)

md_theme_stata(...)

md_theme_tufte(...)

md_theme_wsj(...)
}
\arguments{
\item{...}{Arguments passed on to the corresponding theme in package \code{{ggthemes}}}
}
\value{
An object of class \code{theme} that can be added to any \code{ggplot}
}
\description{
\code{{ggthemes}} themes supporting markdown syntax
}
\examples{
library(ggplot2)
data(mtcars)

p <- ggplot(mtcars, aes(hp, mpg)) +
  geom_point() +
  labs(
    title = "A **bold** title",
    subtitle = "An *italics* subtitle",
    caption = "A <span style = 'color:blue'>blue</span> caption"
  )

# With a 'usual' theme the text is not rendered
p

# By adding an 'md' theme the text is rendered properly
p + md_theme_excel_new()

}
\seealso{
\code{\link[=as_md_theme]{as_md_theme()}}
}
