% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_na_if.R
\name{recode_na_if}
\alias{recode_na_if}
\title{Recode NA as another value with some conditions}
\usage{
recode_na_if(df, grouping_cols = NULL, target_groups = NULL, replacement = 0)
}
\arguments{
\item{df}{A data.frame object with missing values}

\item{grouping_cols}{Character columns to use for grouping the data}

\item{target_groups}{Character Recode NA as if and only if the grouping column is
in this vector of values}

\item{replacement}{Values to use to replace NAs for IDs that meet the requirements.
Defaults to 0.}
}
\description{
Recode NA as another value with some conditions
}
\examples{
some_data <- data.frame(ID=c("A1","A2","A3", "A4"),
A=c(5,NA,0,8), B=c(10,0,0,1),C=c(1,NA,NA,25))
# Replace NAs with 0s only for IDs in A2 and A3
recode_na_if(some_data,"ID",c("A2","A3"),replacement=0)
}
