% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdaplots.R
\name{mdaplot}
\alias{mdaplot}
\title{Plotting function for a single set of objects}
\usage{
mdaplot(data = NULL, plot.data = NULL, type = "p", pch = 16,
  col = NULL, lty = 1, lwd = 1, bwd = 0.8, cgroup = NULL,
  xlim = NULL, ylim = NULL, colmap = "default", labels = NULL,
  main = NULL, xlab = NULL, ylab = NULL, show.labels = F,
  show.colorbar = T, show.lines = F, show.grid = T, show.axes = T,
  xticks = NULL, yticks = NULL, xticklabels = NULL, yticklabels = NULL,
  xlas = 0, ylas = 0, lab.col = "darkgray", lab.cex = 0.65,
  show.excluded = FALSE, col.excluded = "#E0E0E0", nbins = 256,
  colramp = mdaplot.getColors, force.x.values = NA, opacity = 1, ...)
}
\arguments{
\item{data}{a vector, matrix or a data.frame with data values.}

\item{plot.data}{a list of parameters and values obtained after preprocessing of original data provided
by a user (if NULL it will be created automatically)}

\item{type}{type of the plot ('p', 'l', 'b', 'h', 'e', 'i').}

\item{pch}{a character for markers (same as \code{plot} parameter).}

\item{col}{a color for markers or lines (same as \code{plot} parameter).}

\item{lty}{the line type (same as \code{plot} parameter).}

\item{lwd}{the line width (thickness) (same as \code{plot} parameter).}

\item{bwd}{a width of a bar as a percent of a maximum space available for each bar.}

\item{cgroup}{a vector with values to use for make color groups.}

\item{xlim}{limits for the x axis (if NULL, will be calculated automatically).}

\item{ylim}{limits for the y axis (if NULL, will be calculated automatically).}

\item{colmap}{a colormap to use for coloring the plot items.}

\item{labels}{a vector with text labels for data points or one of the following: 'names', 'indices', 'values'.}

\item{main}{an overall title for the plot (same as \code{plot} parameter).}

\item{xlab}{a title for the x axis (same as \code{plot} parameter).}

\item{ylab}{a title for the y axis (same as \code{plot} parameter).}

\item{show.labels}{logical, show or not labels for the data objects.}

\item{show.colorbar}{logical, show or not colorbar legend if color grouping is on.}

\item{show.lines}{vector with two coordinates (x, y) to show horizontal and vertical line cross the point.}

\item{show.grid}{logical, show or not a grid for the plot.}

\item{show.axes}{logical, make a normal plot or show only elements (markers, lines, bars) without axes.}

\item{xticks}{values for x ticks}

\item{yticks}{values for y ticks}

\item{xticklabels}{labels for x ticks.}

\item{yticklabels}{labels for y ticks.}

\item{xlas}{orientation of xticklabels}

\item{ylas}{orientation of yticklabels}

\item{lab.col}{color for data point labels.}

\item{lab.cex}{size for data point labels.}

\item{show.excluded}{logical, show or hide rows marked as excluded (attribute `exclrows`)}

\item{col.excluded}{color for the excluded objects (rows)}

\item{nbins}{if scatter density plot is shown, number of segments to split the plot area into 
(see also ?smoothScatter)}

\item{colramp}{Colramp function for density scatter plot}

\item{force.x.values}{vector with corrected x-values for a bar plot (do not specify this manually)}

\item{opacity}{opacity for plot colors (value between 0 and 1)}

\item{...}{other plotting arguments.}
}
\description{
\code{mdaplot} is used to make different kinds of plot for one set of data objects.
}
\details{
Most of the parameters are similar to what are used with standard \code{plot} function. The 
differences are described below.
  
The function makes a plot of one set of objects. It can be a set of points (scatter plot), 
bars, lines, scatter-lines, errorbars og an image. The data is organized as a data frame, 
matrix or vector. For scatter and only first two columns will be used, for bar plot only 
values from the first row. It is recommended to use \code{\link{mda.subset}} method if plot 
should be made only for a subset of the data, especially if you have any excluded rows or 
columns or other special attributed, described in the Bookdown tutorial.

If data is a data frame and contains one or more factors, they will be converted to a dummy
variables (using function \code{\link{mda.df2mat}}) and appears at the end (last columns) if 
line or bar plot is selected.
 
The function allows to colorize lines and points according to values of a parameter 
\code{cgroup}. The parameter must be a vector with the same elements as number of objects (rows)
in the data. The values are divided into up to eight intervals and for each interval a 
particular color from a selected color scheme is assigned. Parameter \code{show.colorbar} 
allows to turn off and on a color bar legend for this option.

The used color scheme is defined by the \code{colmap} parameter. The default scheme is based
on color brewer (colorbrewer2.org) diverging scheme with eight colors. There is also a gray 
scheme (\code{colmap = 'gray'}) and user can define its own just by specifing the needed 
sequence of colors (e.g. \code{colmap = c('red', 'yellow', 'green')}, two colors is minimum). 
The scheme will then be generated automatically as a gradient among the colors.  

Besides that the function allows to change tick values and corresponding tick labels for x and 
y axis, see Bookdown tutorial for more details.
}
\examples{
# See all examples in the tutorial.

}
\seealso{
\code{\link{mdaplotg}} - to make plots for several sets of data objects (groups of objects).
}
\author{
Sergey Kucheryavskiy (svkucheryavski@gmail.com)
}
