% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plsda.R
\name{plsda.cal}
\alias{plsda.cal}
\title{Calibrate PLS-DA model}
\usage{
plsda.cal(x, c, ncomp, center, scale, cv, method, light, alpha, coeffs.ci,
  coeffs.alpha, info, exclcols = NULL, exclrows = NULL, ncomp.selcrit)
}
\arguments{
\item{x}{matrix with predictors.}

\item{c}{vector with reference class values.}

\item{ncomp}{maximum number of components to calculate.}

\item{center}{logical, center or not predictors and response values.}

\item{scale}{logical, scale (standardize) or not predictors and response values.}

\item{cv}{number of segments for cross-validation (if cv = 1, full cross-validation will be used).}

\item{method}{method for calculating PLS model.}

\item{light}{run normal or light (faster) version of PLS without calculationg some performance statistics.}

\item{alpha}{significance level for calculating statistical limits for residuals.}

\item{coeffs.ci}{method to calculate p-values and confidence intervals for regression coefficients (so far only 
jack-knifing is availavle: \code{='jk'}).}

\item{coeffs.alpha}{significance level for calculating confidence intervals for regression coefficients.}

\item{info}{short text with information about the model.}

\item{exclcols}{columns of x to be excluded from calculations (numbers, names or vector with logical values)}

\item{exclrows}{rows to be excluded from calculations (numbers, names or vector with logical values)}

\item{ncomp.selcrit}{criterion for selecting optimal number of components (\code{'min'} for first local minimum of}
}
\description{
Calibrate PLS-DA model
}

