% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotseries.R
\name{plotConfidenceEllipse}
\alias{plotConfidenceEllipse}
\title{Add confidence ellipse for groups of points on scatter plot}
\usage{
plotConfidenceEllipse(p, conf.level = 0.95, lwd = 1, lty = 1, opacity = 0)
}
\arguments{
\item{p}{plot data returned by function `mdaplot()`.}

\item{conf.level}{confidence level to make the ellipse for (between 0 and 1).}

\item{lwd}{thickness of line used to show the hull.}

\item{lty}{type of line used to show the hull.}

\item{opacity}{of opacity is 0 ellipse is transparent otherwise semi-transparent.}
}
\description{
The method shows confidence ellipse for groups of points on a scatter plot made using
`mdaplot()` function with `cgroup` parameter. It will work only if `cgroup` is a factor.
}
\examples{
# adds 90\% confidence ellipse with semi-transparent area over two clusters of points

library(mdatools)
data(people)
group <- factor(people[, "Sex"], labels = c("Male", "Female"))

# first make plot and then add confidence ellipse
p <- mdaplot(people, type = "p", cgroup = group)
plotConfidenceEllipse(p, conf.level = 0.90, opacity = 0.2)

}
