% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_mc.R
\name{expect_mc_test}
\alias{expect_mc_test}
\title{Test if p-values are coming from the null using a sequential
approach.}
\usage{
expect_mc_test(object, control = NULL, npval = 1)
}
\arguments{
\item{object}{A function taking one argument n  - that generates p-values based on a sample size n.}

\item{control}{a list controlling the algorithm
\itemize{
\item n number of samples to be taken in the first step. Default: 1e3
\item maxseqsteps: Number of sequential attempts to use. Default: 7.
\item incn: Factor by which to multiply n from the second  sequential attempt onwards. Default: 4.
\item level: bound on the type I error, ie the probability of wrongly rejecting a sampler with the correct distribution. Default: 1e-5.
\item debug: If positive  then debug information will be printed via 'message()'. Default: 0.
}}

\item{npval}{number of p-values returned by the test. A Bonferroni correction is applied if >1. Default: 1.}
}
\value{
The first argument, invisibly, to allow chaining of expectations.
}
\description{
Requires as input a generic test that for a given sample size
provides a vector of p-values. Aims to reject if these are not from
the null. Guarantees a bound on the type I error rate.
}
\examples{
pvalsampler <- function(n){
      x <- sample.int(11,size=n,replace=TRUE)-1;
     chisq.test(tabulate(x+1,nbins=11),
                p=rep(1/11,11))$p.value
}
expect_mc_test(pvalsampler)

}
