% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vca.R
\name{anovaVCA}
\alias{anovaVCA}
\title{ANOVA-Type Estimation of Variance Components for Random Models}
\usage{
anovaVCA(...)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[VCA:anovaVCA]{VCA::anovaVCA}}
  \describe{
    \item{\code{form}}{(formula) specifying the model to be fit, a response variable left of the '~' is mandatory}
    \item{\code{Data}}{(data.frame) containing all variables referenced in 'form'}
    \item{\code{by}}{(factor, character) variable specifying groups for which the analysis should be performed individually,
i.e. by-processing}
    \item{\code{NegVC}}{(logical) FALSE = negative variance component estimates (VC) will be set to 0 and they will not contribute to the total variance 
(as done in SAS PROC NESTED, conservative estimate of total variance). The original ANOVA estimates can be found in element 'VCoriginal'. 
The degrees of freedom of the total variance are based on adapted mean squares (MS), i.e. adapted MS are computed as \eqn{D * VC}, where VC is 
the column vector with negative VCs set to 0. \cr
TRUE = negative variance component estimates will not be set to 0 and they will contribute to the total variance (original definition of the total variance).}
    \item{\code{VarVC.method}}{(character) string specifying whether to use the algorithm given in Searle et al. (1992) which corresponds to \code{VarVC.method="scm"} or in
Giesbrecht and Burns (1985) which can be specified via "gb". Method "scm" (Searle, Casella, McCulloch)
is the exact algorithm, "gb" (Giesbrecht, Burns) is termed "rough approximation"
by the authors, but sufficiently exact compared to e.g. SAS PROC MIXED (method=type1) which
uses the inverse of the Fisher-Information matrix as approximation. For balanced designs all
methods give identical results, only in unbalanced designs differences occur.}
    \item{\code{MME}}{(logical) TRUE = (M)ixed (M)odel (E)quations will be solved, i.e. 'VCA' object will have additional elements
"RandomEffects", "FixedEffects", "VarFixed" (variance-covariance matrix of fixed effects) and the "Matrices"
element has addional elements corresponding to intermediate results of solving MMEs.
FALSE = do not solve MMEs, which reduces the computation time for very complex models significantly.}
    \item{\code{quiet}}{(logical) TRUE = will suppress any warning, which will be issued otherwise}
    \item{\code{order.data}}{(logical) TRUE = class-variables will be ordered increasingly, FALSE = ordering of class-variables
will remain as is}
  }}
}
\value{
a class of \code{VCA} for downstream analysis.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A copy from \link[VCA:anovaVCA]{VCA::anovaVCA} in \code{VCA} package
}
\examples{
data(glucose)
anovaVCA(value ~ day / run, glucose)
}
\seealso{
\code{\link[VCA:anovaVCA]{VCA::anovaVCA()}}
}
