% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{maximize_llh}
\alias{maximize_llh}
\title{Maximize log-likelihood defined inside a sampler function}
\usage{
maximize_llh(sampler, method = "BFGS", control = list(fnscale = -1), ...)
}
\arguments{
\item{sampler}{sampler function.}

\item{method}{optimization method, passed to \code{\link[stats]{optim}}.}

\item{control}{control parameters, passed to \code{\link[stats]{optim}}.}

\item{...}{other parameters passed to \code{\link[stats]{optim}}.}
}
\value{
A list of parameter values that, provided the optimization was successful, maximize the likelihood.
}
\description{
Maximize log-likelihood defined inside a sampler function
}
\examples{
\donttest{
n <- 1000
dat <- data.frame(
  x = rnorm(n),
  f = factor(sample(1:50, n, replace=TRUE))
)
df <- generate_data(
  ~ reg(~x, name="beta", Q0=1) + gen(~x, factor=~f, name="v"),
  sigma.fixed=TRUE, data=dat
)
dat$y <- df$y
sampler <- create_sampler(y ~ x + gen(~x, factor=~f, name="v"), data=dat)
opt <- maximize_llh(sampler)
str(opt)
plot(df$par$v, opt$par$v); abline(0, 1, col="red")
}

}
