% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{compress}
\alias{compress}
\title{Transform data to compact representation given by max-stable PCA}
\usage{
compress(fit, data)
}
\arguments{
\item{fit, }{max_stable_prcomp object. Data should be
assumed to follow the same distribution as the data used in
max_stable_prcomp.}

\item{data, }{array with same number of columns as the
data of the fit object.}
}
\value{
An array of shape nrow(data), p giving the
encoded representation of the data in p components which are
also unit Frechet distributed which is to be takin into consideration for
further analysis.
}
\description{
Turn the given data into a compressed latent representation
given by the fit of the max_stable_prcomp function.
This is done by taking the max-matrix product of the data
and the encoder matrix from the fit.
}
\examples{
# generate some data with the desired margins
dat <- matrix(evd::rfrechet(300), 100, 3)
maxPCA <- max_stable_prcomp(dat, 2)

#  look at summary to obtain further information about 
# loadings the space spanned and loss function
summary(maxPCA)

# transfrom data to compressed representation
# for a representation that is p-dimensional,
# preserves the max-stable structure and is numeric solution to 
# optimal reconstruction.
compr <- compress(maxPCA, dat)

# For visual examination reconstruct original vector from compressed representation
rec <- reconstruct(maxPCA, dat)
}
\seealso{
\code{\link[=max_stable_prcomp]{max_stable_prcomp()}}, \code{\link[=maxmatmul]{maxmatmul()}}
}
