% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Binary.R
\name{and_byname}
\alias{and_byname}
\title{And "by name"}
\usage{
and_byname(...)
}
\arguments{
\item{...}{operands to the logical \code{and} function}
}
\value{
logical \code{and} applied to the operands
}
\description{
Operands should be logical, although numerical operands are accepted.
Numerical operands are interpreted as \code{FALSE} when \code{0} and
\code{TRUE} for any other number.
}
\examples{
and_byname(TRUE)
and_byname(FALSE)
and_byname(list(TRUE, FALSE), list(TRUE, TRUE), list(TRUE, TRUE), list(TRUE, TRUE))
m1 <- matrix(c(TRUE, TRUE, TRUE, FALSE), nrow = 2, ncol = 2, 
  dimnames = list(c("r1", "r2"), c("c1", "c2")))
m2 <- matrix(c(TRUE, FALSE, TRUE, TRUE), nrow = 2, ncol = 2,
  dimnames = list(c("r1", "r2"), c("c1", "c2")))
and_byname(m1, m1)
and_byname(m1, m2)
and_byname(list(m1, m1), list(m1, m1), list(m2, m2))
}
