% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{prep_vector_arg}
\alias{prep_vector_arg}
\title{Prepare a vector argument}
\usage{
prep_vector_arg(a, vector_arg)
}
\arguments{
\item{a}{a matrix or list of matrices}

\item{vector_arg}{the vector argument over which to apply a calculation}
}
\value{
\code{vector_arg}, possibly modified when \code{a} is a list
}
\description{
This is a helper function for many \verb{*_byname} functions.
}
\details{
It is potentially ambiguous to specify a vector or matrix argument, say, \code{margin = c(1, 2)} when applying
the \verb{*_byname} functions to unary list of \code{a}.
Rather, one should specify, say, \verb{margin = list(c(1, 2)}
to avoid ambiguity.
If \code{a} is a list,
\code{vector_arg} is not a list and has length > 1 and length not equal to the length of a,
this function returns a list value for \code{vector_arg}.
If \code{a} is not a list and \code{vector_arg} is a list,
this function returns an un-recursive, unlisted version of \code{vector_arg}.

Note that if \code{vector_arg} is a single matrix, it is automatically enclosed by a list when \code{a} is a list.
}
\examples{
m <- matrix(c(2, 2))
matsbyname:::prep_vector_arg(list(m, m), vector_arg = c(1,2))
}
