% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R
\name{join}
\alias{join}
\alias{join_row_info}
\alias{join_column_info}
\title{Add meta info from another \code{matrixset} or a \code{data.frame}}
\usage{
join_row_info(
  .ms,
  y,
  type = "left",
  by = NULL,
  adjust = FALSE,
  suffix = c(".x", ".y"),
  na_matches = c("na", "never")
)

join_column_info(
  .ms,
  y,
  type = "left",
  by = NULL,
  adjust = FALSE,
  suffix = c(".x", ".y"),
  na_matches = c("na", "never")
)
}
\arguments{
\item{.ms}{A \code{matrixset} object}

\item{y}{A \code{matrixset} object or a \code{data.frame}.}

\item{type}{Joining type, one of \code{"left"} (default), \code{"inner"},
\code{"right"} or \code{"full"}}

\item{by}{The names of the variable to join by.
The default, \code{NULL}, results in slightly different
behavior depending if \code{y} is a \code{matrixset} or a
\code{data.frame}.
If a \code{matrixset}, the meta info tag of each object (the
tag is the column that holds the row names/column names
in the meta info data frame - typically ".rowname" or
".colname" unless specified otherwise at \code{matrixset}
creation) is used for \code{by}.
If a \code{data.frame}, a natural join is used. For more
details, see \code{dplyr}'s \code{\link[dplyr:mutate-joins]{dplyr::join()}}.
Note that the cross-join is not available.}

\item{adjust}{A logical. By default (\code{FALSE}), the join operation is
not permitted to filter or augment the number of rows of
the meta info data frame.
If \code{TRUE}, this will be allowed. In the case where the
data frame is augmented, the matrices of \code{.ms}
will be augmented accordingly by padding with \code{NA}s (
except for the \code{NULL}matrices).}

\item{suffix}{Suffixes added to disambiguate trait variables. See
\code{dplyr}'s \code{\link[dplyr:mutate-joins]{dplyr::join()}}.}

\item{na_matches}{How to handle missing values when matching. See
\code{dplyr}'s \code{\link[dplyr:mutate-joins]{dplyr::join()}}.}
}
\value{
A \code{matrixset} with updated row or column meta info, with all \code{.ms} traits and
\code{y} traits. If some traits share the same names - and were not included in
\code{by} - \code{suffix}es will be appended to these names.

If adjustment was allowed, the dimensions of the new \code{matrixset} may differ
from the original one.
}
\description{
The operation is done through a join operation between the row meta info
data.frame (\code{\link[=join_row_info]{join_row_info()}}) of \code{.ms} and \code{y} (or its row meta info
data.frame if it is a \code{matrixset} object). The function \code{\link[=join_column_info]{join_column_info()}}
does the equivalent operation for column meta info.

The default join operation is a left join (type == \code{"left"}), but all dplyr's
mutating joins are available (\code{"left"}, \code{"inner"}, \code{"right"} and \code{"full"}).

The \code{matrixset} paradigm of unique row/column names is enforced so if a
\code{.ms} data.frame row matches multiple ones in \code{y}, this results in an
error.
}
\section{Groups}{

When \code{y} is a \code{matrixset}, only groups from \code{.ms} are used, if any. Group
update is the same as in \code{dplyr}.
}

\examples{
ms1 <- remove_row_annotation(student_results, class, teacher)
ms <- join_row_info(ms1, student_results)

ms <- join_row_info(ms1, student_results, by = c(".rowname", "previous_year_score"))

# This will throw an error
ms2 <- remove_row_annotation(filter_row(student_results, class \%in\% c("classA", "classC")),
                             class, teacher, previous_year_score)
ms <- ms <- tryCatch(join_row_info(ms2, student_results, type = "full"),
                     error = function(e) e)
is(ms, "error") # TRUE
ms$message

# Now it works.
ms <- join_row_info(ms2, student_results, type = "full", adjust = TRUE)
dim(ms2)
dim(ms)
matrix_elm(ms, 1)

}
