% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixpls.postestimation.R
\name{predict.matrixpls}
\alias{predict.matrixpls}
\title{Predict method for matrixpls results}
\usage{
\method{predict}{matrixpls}(object, newdata, ...)
}
\arguments{
\item{object}{matrixpls estimation result object produced by the \code{\link{matrixpls}} function.}

\item{newdata}{A data frame or a matrix containing data used for prediction.}

\item{...}{All other arguments are ignored.}
}
\value{
a matrix of predicted values for reflective indicators of endogenous latent variables.
}
\description{
The \code{matrixpls} method for the generic function \code{predict} predict.
Predicts the reflective indicators of endogenous latent variables using
estimated model and data for the indicators of exogenous latent variables
}
\references{
Wold, H. (1974). Causal flows with latent variables: Partings of the ways in the light of NIPALS modelling. \emph{European Economic Review}, 5(1), 67–86. doi:10.1016/0014-2921(74)90008-7
}
\seealso{
Other post-estimation functions: \code{\link{ave}},
  \code{\link{cr}}, \code{\link{effects.matrixpls}},
  \code{\link{fitSummary}}, \code{\link{fitted.matrixpls}},
  \code{\link{gof}}, \code{\link{htmt}},
  \code{\link{loadings.matrixpls}}, \code{\link{r2}},
  \code{\link{residuals.matrixpls}}
}

