% Generated by roxygen2 (4.0.2): do not edit by hand
\name{params.tsls}
\alias{params.tsls}
\title{Parameter estimation with two-stage least squares}
\usage{
params.tsls(S, model, W, ...)
}
\arguments{
\item{S}{Covariance matrix of the data.}

\item{model}{There are two options for this argument: 1. lavaan script or lavaan parameter
table, or 2. a list containing three matrices
\code{inner}, \code{reflective}, and \code{formative} defining the free regression paths
in the model.}

\item{W}{Weight matrix, where the indicators are on colums and composites are on the rows.}

\item{...}{All other arguments are passed through to \code{weightFunction} and \code{parameterEstimator}.}
}
\value{
A named vector of parameter estimates.
}
\description{
Estimates the model parameters with weighted composites using two-stage least squares
}
\details{
\code{params.tsls} estimates the statistical model described by \code{model} with the
following steps. If \code{model} is not in the native format, it is converted to the native
format containing matrices \code{inner}, \code{reflective}, and \code{formative}. The
weights \code{W} and the data covariance matrix \code{S} are used to calculate the composite
covariance matrix \code{C} and the indicator-composite covariance matrix \code{IC}. These
are used to estimate multiple regression models with two-stage least squares for
inner model and OLS regressions for the outer model.
}
\seealso{
Other parameter estimators: \code{\link{params.plsc}};
  \code{\link{params.plsregression}};
  \code{\link{params.regression}}
}

