% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2.iph.R
\name{cdf,iph-method}
\alias{cdf,iph-method}
\title{Distribution Method for inhomogeneous phase type distributions}
\usage{
\S4method{cdf}{iph}(x, q = seq(0, quan(x, 0.95)$quantile, length.out = 10), lower.tail = TRUE)
}
\arguments{
\item{x}{an object of class \linkS4class{iph}.}

\item{q}{a vector of locations.}

\item{lower.tail}{logical parameter specifying whether lower tail (cdf) or upper tail is computed.}
}
\value{
A list containing the locations and corresponding CDF evaluations.
}
\description{
Distribution Method for inhomogeneous phase type distributions
}
\examples{
obj <- iph(ph(structure = "general"), gfun = "weibull", gfun_pars = 2)
cdf(obj, c(1, 2, 3))
}
