% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mxbeta.R
\name{mxbeta}
\alias{mxbeta}
\alias{dmxbeta1}
\alias{dmxbeta2}
\alias{rmxbeta1}
\alias{rmxbeta2}
\title{Matrix Variate Beta Distributions.}
\usage{
dmxbeta1(X, a, b)

dmxbeta2(X, a, b)

rmxbeta1(n, p, a, b, S)

rmxbeta2(n, p, a, b)
}
\arguments{
\item{X}{a \code{(p-by-p)} matrix whose density be computed.}

\item{a}{positive real number \code{> (p-1)/2}.}

\item{b}{positive real number \code{> (p-1)/2}.}

\item{n}{the number of samples to be generated.}

\item{p}{the dimension for sample matrix.}

\item{S}{a \code{(p-by-p)} covariance matrix required for Type 1 Beta sampling.}
}
\description{
We have 2 types of Beta distributions, namely, Type 1 and Type 2.
Like other functions, \code{dmxbeta1} and \code{dmxbeta2} are
to evaluate densities, while \code{rmxbeta1} and \code{rmxbeta2} generate
random samples accordingly to the model provided.
}
\examples{
## Sample Generations
sbeta1 = rmxbeta1(10, p=4, a=6, b=2, S=diag(4))
sbeta2 = rmxbeta2(10, p=4, a=6, b=2)

}
