% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/roommate.R
\name{roommate.checkPreferences}
\alias{roommate.checkPreferences}
\title{Check if preference order for a one-sided market is complete}
\usage{
roommate.checkPreferences(pref)
}
\arguments{
\item{pref}{is a matrix with the preference order of each individual in the
market. This argument is only required when \code{utils} is not provided.
If there are \code{n} individuals, then this matrix will be of dimension
\code{n-1} by \code{n}. The \code{i,j}th element refers to \code{j}'s
\code{i}th most favorite partner. Preference orders can either be specified
using R-indexing (starting at 1) or C++ indexing (starting at 0). The
matrix \code{pref} must be of dimension \code{n-1} by \code{n}. Otherwise,
the function will throw an error.}
}
\value{
a matrix with preference orderings with proper C++ indices or NULL if
  the preference order is not complete.
}
\description{
Check if preference order for a one-sided market is complete
}

