% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/matchingR.R
\name{one2one}
\alias{A}
\alias{\code{engagements}}
\alias{\code{proposals}}
\alias{\code{single.proposers}}
\alias{\code{single.reviewers}}
\alias{a}
\alias{and}
\alias{contains}
\alias{element}
\alias{engagements:}
\alias{id}
\alias{ids}
\alias{is}
\alias{list}
\alias{lists}
\alias{matched}
\alias{n}
\alias{nth}
\alias{of}
\alias{one2one}
\alias{proposals}
\alias{proposer}
\alias{proposers.}
\alias{remaining}
\alias{reviewer}
\alias{reviewers.}
\alias{single}
\alias{successful}
\alias{that}
\alias{the}
\alias{to.}
\alias{vector}
\alias{whose}
\alias{with}
\title{Compute one-to-one matching}
\usage{
one2one(proposerUtils = NULL, reviewerUtils = NULL, proposerPref = NULL,
  reviewerPref = NULL)
}
\arguments{
\item{proposerUtils}{is a matrix with cardinal utilities of the proposing
side of the market}

\item{reviewerUtils}{is a matrix with cardinal utilities of the courted side
of the market}

\item{proposerPref}{is a matrix with the preference order of the proposing
side of the market (only required when \code{proposerUtils} is not
provided)}

\item{reviewerPref}{is a matrix with the preference order of the courted side
of the market (only required when \code{reviewerUtils} is not provided)}
}
\description{
This function returns the proposer-optimal one-to-one matching. The function
needs some description of individuals preferences as inputs. That can be in
the form of cardinal utilities or preference orders (or both).
}
\examples{
nmen = 25
nwomen = 20
uM = matrix(runif(nmen*nwomen), nrow=nmen, ncol=nwomen)
uW = matrix(runif(nwomen*nmen), nrow=nwomen, ncol=nmen)
results = one2one(uM, uW)

prefM = sortIndex(uM)
prefW = sortIndex(uW)
results = one2one(proposerPref = prefM, reviewerPref = prefW)
}

