/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.automata.fast_multicostregular.example;

import choco.Choco;
import choco.cp.model.CPModel;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.global.automata.fast_multicostregular.example.CoverVarValSelector;
import choco.cp.solver.search.integer.branching.AssignVar;
import choco.cp.solver.search.integer.valiterator.IncreasingDomain;
import choco.cp.solver.search.integer.varselector.StaticVarOrder;
import choco.kernel.common.util.tools.ArrayUtils;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.automaton.FA.FiniteAutomaton;
import choco.kernel.model.constraints.automaton.FA.IAutomaton;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerExpressionVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.branch.VarSelector;
import choco.kernel.solver.variables.integer.IntDomainVar;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.RegExp;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;

public class RuleModel
extends CPModel {
    Automaton full;
    TIntHashSet alpha;
    String work;
    String all;
    IntegerVariable[][] vs;
    IntegerVariable[][] cvs;

    public RuleModel() {
        int[] tmp = new int[]{0, 1, 2};
        this.alpha = new TIntHashSet();
        this.alpha.addAll(tmp);
        this.work = "(";
        for (int i = 0; i < tmp.length - 1; ++i) {
            this.work = this.work + tmp[i] + "|";
        }
        this.work = this.work.substring(0, this.work.length() - 1) + ")";
        this.all = "(" + tmp[2] + "|" + this.work.substring(1, this.work.length());
    }

    public void buildConsecutiveWERule() {
        int i;
        int j;
        String frule = "((";
        for (j = 0; j < 3; ++j) {
            for (i = 0; i < 5; ++i) {
                frule = frule + this.all;
            }
            frule = frule + this.work;
            frule = frule + this.work;
        }
        for (j = 0; j < 7; ++j) {
            frule = frule + this.all;
        }
        frule = frule + ")|(";
        for (j = 0; j < 7; ++j) {
            frule = frule + this.all;
        }
        for (j = 0; j < 3; ++j) {
            for (i = 0; i < 5; ++i) {
                frule = frule + this.all;
            }
            frule = frule + this.work;
            frule = frule + this.work;
        }
        frule = frule + "))";
        this.full = new RegExp(StringUtils.toCharExp(frule)).toAutomaton().complement();
    }

    public void buildNoNightBeforeFreeWE() {
        int i;
        int j;
        int i2;
        String ret = "((";
        for (i2 = 0; i2 < 4; ++i2) {
            ret = ret + this.all;
        }
        ret = ret + "122";
        for (j = 0; j < 3; ++j) {
            for (i = 0; i < 7; ++i) {
                ret = ret + this.all;
            }
        }
        ret = ret + ")|(";
        for (i2 = 0; i2 < 7; ++i2) {
            ret = ret + this.all;
        }
        for (i2 = 0; i2 < 4; ++i2) {
            ret = ret + this.all;
        }
        ret = ret + "122";
        for (j = 0; j < 2; ++j) {
            for (i = 0; i < 7; ++i) {
                ret = ret + this.all;
            }
        }
        ret = ret + ")|(";
        for (j = 0; j < 2; ++j) {
            for (i = 0; i < 7; ++i) {
                ret = ret + this.all;
            }
        }
        for (i2 = 0; i2 < 4; ++i2) {
            ret = ret + this.all;
        }
        ret = ret + "122";
        for (i2 = 0; i2 < 7; ++i2) {
            ret = ret + this.all;
        }
        ret = ret + ")|(";
        for (j = 0; j < 3; ++j) {
            for (i = 0; i < 7; ++i) {
                ret = ret + this.all;
            }
        }
        for (i2 = 0; i2 < 4; ++i2) {
            ret = ret + this.all;
        }
        ret = ret + "122";
        ret = ret + "))";
        this.full = this.full.intersection(new RegExp(StringUtils.toCharExp(ret)).toAutomaton().complement());
        this.full.minimize();
    }

    public void buildNoMoreThanDayRule() {
        String ret = this.all + "*";
        for (int i = 0; i < 6; ++i) {
            ret = ret + this.work;
        }
        ret = ret + this.all + "*";
        this.full = this.full.intersection(new RegExp(StringUtils.toCharExp(ret)).toAutomaton().complement());
        this.full.minimize();
    }

    public void buildRestAfterNight() {
        String ret = this.all + "*";
        ret = ret + "1+0";
        ret = ret + this.all + "*";
        this.full = this.full.intersection(new RegExp(StringUtils.toCharExp(ret)).toAutomaton().complement());
        this.full.minimize();
    }

    public void buildCompleteWE() {
        StringBuffer b = new StringBuffer("(");
        String patter = "((2(0|1))|((0|1)2))";
        int nd = 2;
        int nw = 4;
        int sd = 6;
        for (int w = 0; w < nw; ++w) {
            int i;
            b.append("(");
            for (i = 1; i < sd + 7 * w; ++i) {
                b.append(this.all);
            }
            b.append(patter);
            for (i = sd + 7 * w + nd; i <= 28; ++i) {
                b.append(this.all);
            }
            b.append(")|");
        }
        b.deleteCharAt(b.length() - 1).append(")");
        this.full = this.full.intersection(new RegExp(StringUtils.toCharExp(b.toString())).toAutomaton().complement());
        this.full.minimize();
    }

    void fillModel() {
        int j;
        int i;
        this.vs = Choco.makeIntVarArray("x", 8, 28, 0, 2, new String[0]);
        int[][][] csts = new int[this.vs[0].length][3][7];
        for (i = 0; i < csts.length; ++i) {
            for (int j2 = 0; j2 < csts[i].length; ++j2) {
                if (j2 == 0 || j2 == 1) {
                    csts[i][j2][4] = 1;
                }
                if (j2 == 1) {
                    csts[i][j2][5] = 1;
                }
                if (j2 == 2) {
                    csts[i][j2][6] = 1;
                }
                if (j2 != 0 && j2 != 1) continue;
                csts[i][j2][i / 7] = 1;
            }
        }
        this.cvs = new IntegerVariable[8][7];
        for (i = 0; i < 4; ++i) {
            Variable[] tmp = this.cvs[i];
            tmp[4] = Choco.makeIntVar("z_{" + i + ",0}", 0, 18, "cp:bound");
            tmp[5] = Choco.makeIntVar("z_{" + i + ",1}", 0, 4, "cp:bound");
            tmp[6] = Choco.makeIntVar("z_{" + i + ",2}", 10, 28, "cp:bound");
            for (j = 0; j < 4; ++j) {
                tmp[j] = Choco.makeIntVar("z_{" + i + "," + j + "}", 4, 5, "cp:bound");
            }
            this.addVariables(tmp);
            this.addVariables(this.vs[i]);
        }
        for (i = 4; i < 8; ++i) {
            Variable[] tmp = this.cvs[i];
            tmp[4] = Choco.makeIntVar("z_{" + i + ",0}", 0, 10, "cp:bound");
            tmp[5] = Choco.makeIntVar("z_{" + i + ",1}", 0, 4, "cp:bound");
            tmp[6] = Choco.makeIntVar("z_{" + i + ",1}", 18, 28, "cp:bound");
            for (j = 0; j < 4; ++j) {
                tmp[j] = Choco.makeIntVar("z_{" + i + "," + j + "}", 2, 3, "cp:bound");
            }
            this.addVariables(tmp);
            this.addVariables(this.vs[i]);
        }
        FiniteAutomaton auto = new FiniteAutomaton();
        auto.fill(this.full, this.alpha);
        for (int i2 = 0; i2 < 8; ++i2) {
            Constraint mr = Choco.multiCostRegular(this.cvs[i2], this.vs[i2], (IAutomaton)auto, csts);
            this.addConstraint(mr);
        }
        int[] low = new int[]{3, 1, 4};
        int[] up = new int[]{3, 1, 4};
        IntegerVariable[][] trans = ArrayUtils.transpose(this.vs);
        for (int i3 = 0; i3 < 28; ++i3) {
            this.addConstraint("cp:bc", Choco.globalCardinality(trans[i3], low, up, 0));
        }
    }

    public void addMinCoverConstraint() {
        IntegerExpressionVariable[] worked = ArrayUtils.transpose(this.cvs)[4];
        IntegerExpressionVariable[] night = ArrayUtils.transpose(this.cvs)[5];
        IntegerExpressionVariable[] rest = ArrayUtils.transpose(this.cvs)[6];
        this.addConstraint(Choco.eq(Choco.sum(worked), 112));
        this.addConstraint(Choco.eq(Choco.sum(night), 28));
        this.addConstraint(Choco.eq(Choco.sum(rest), 112));
        IntegerExpressionVariable[] week0 = ArrayUtils.transpose(this.cvs)[0];
        this.addConstraint(Choco.eq(Choco.sum(week0), 28));
        IntegerExpressionVariable[] week1 = ArrayUtils.transpose(this.cvs)[1];
        this.addConstraint(Choco.eq(Choco.sum(week1), 28));
        IntegerExpressionVariable[] week2 = ArrayUtils.transpose(this.cvs)[2];
        this.addConstraint(Choco.eq(Choco.sum(week2), 28));
        IntegerExpressionVariable[] week3 = ArrayUtils.transpose(this.cvs)[3];
        this.addConstraint(Choco.eq(Choco.sum(week3), 28));
    }

    public void addLexConstraint() {
        IntegerVariable[][] a = new IntegerVariable[2][28];
        IntegerVariable[][] b = new IntegerVariable[3][28];
        System.arraycopy(this.vs[0], 0, a[0], 0, a[0].length);
        System.arraycopy(this.vs[2], 0, a[1], 0, a[1].length);
        System.arraycopy(this.vs[5], 0, b[0], 0, b[0].length);
        System.arraycopy(this.vs[6], 0, b[1], 0, b[1].length);
        System.arraycopy(this.vs[7], 0, b[2], 0, b[2].length);
    }

    public void addMandatoryShift() {
        this.addConstraint(Choco.eq((IntegerExpressionVariable)this.vs[0][0], 0));
        this.addConstraint(Choco.eq((IntegerExpressionVariable)this.vs[0][1], 0));
        this.addConstraint(Choco.eq((IntegerExpressionVariable)this.vs[2][0], 0));
        this.addConstraint(Choco.eq((IntegerExpressionVariable)this.vs[2][1], 0));
        this.addConstraint(Choco.eq((IntegerExpressionVariable)this.vs[3][0], 1));
        this.addConstraint(Choco.eq((IntegerExpressionVariable)this.vs[3][1], 1));
        this.addConstraint(Choco.eq((IntegerExpressionVariable)this.vs[4][0], 0));
        this.addConstraint(Choco.eq((IntegerExpressionVariable)this.vs[4][1], 0));
    }

    public static void main(String[] args) {
        RuleModel m = new RuleModel();
        m.buildConsecutiveWERule();
        m.buildNoNightBeforeFreeWE();
        m.buildNoMoreThanDayRule();
        m.buildRestAfterNight();
        m.buildCompleteWE();
        m.fillModel();
        m.addLexConstraint();
        m.addMandatoryShift();
        m.addMinCoverConstraint();
        CPSolver s = new CPSolver();
        s.read(m);
        ArrayList<IntDomainVar> mars = new ArrayList<IntDomainVar>();
        for (int i = 0; i < 8; ++i) {
            mars.add(s.getVar(m.cvs[i][4]));
        }
        int[][] lowb = new int[28][3];
        for (int i = 0; i < lowb.length; ++i) {
            lowb[i][0] = 3;
            lowb[i][1] = 1;
            lowb[i][2] = 4;
        }
        CoverVarValSelector sel = new CoverVarValSelector(s, m.vs, lowb);
        s.attachGoal(new AssignVar((VarSelector)new StaticVarOrder(s, s.getVar(ArrayUtils.flatten(ArrayUtils.transpose(m.vs)))), new IncreasingDomain()));
        if (s.solve().booleanValue()) {
            int i = 0;
            for (IntegerVariable[] va : m.vs) {
                for (IntDomainVar v : s.getVar(va)) {
                    System.out.print(RuleModel.toChar(v.getVal()) + " ");
                }
                System.out.print("     |   ");
                for (IntDomainVar v : s.getVar(m.cvs[i++])) {
                    System.out.print(v.getVal() + " ");
                }
                System.out.println("");
            }
        }
        s.printRuntimeStatistics();
    }

    static char toChar(int i) {
        switch (i) {
            case 0: {
                return 'D';
            }
            case 1: {
                return 'N';
            }
            case 2: {
                return 'R';
            }
        }
        return 'E';
    }
}

