% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stitch_two_nets.R
\name{stitch_two_nets}
\alias{stitch_two_nets}
\title{Stitch two treated-to-control networks into one two-part networks.}
\usage{
stitch_two_nets(net1, net2, lambda, controls = 1, overflow = FALSE)
}
\arguments{
\item{net1}{A list of five vectors: startn, endn, ucap, cost, b.}

\item{net2}{A list of five vectors: startn, endn, ucap, cost, b.}

\item{lambda}{A penalty.}

\item{controls}{Number of controls matched to each treated.}

\item{overflow}{A logical value indicating if overflow protection is turned on.}
}
\value{
This function returns a list of five vectors:
startn, endn, ucap, cost, b.
}
\description{
This function takes as inputs two networks and one penalty lambda,
and constructs one two-part network out of them.
}
\details{
This function is of limited interest to users. Once overflow is set to
TRUE, each cotnrol in the first network will be directly connected to
the sink at a large cost, so that the network flow problem is feasible
as long as the first part is feasible.
}
