% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_data.R
\name{mash_set_data}
\alias{mash_set_data}
\title{Create a data object for mash analysis.}
\usage{
mash_set_data(
  Bhat,
  Shat = NULL,
  alpha = 0,
  df = Inf,
  pval = NULL,
  V = diag(ncol(Bhat)),
  zero_check_tol = .Machine$double.eps,
  zero_Bhat_Shat_reset = 0,
  zero_Shat_reset = 0
)
}
\arguments{
\item{Bhat}{An N by R matrix of observed estimates.}

\item{Shat}{An N by R matrix of corresponding standard errors. Shat
can be a scalar if all standard errors are equal. This is most
useful if Bhat is a matrix of Z scores, so elements of Shat are all
1. Default is 1.}

\item{alpha}{Numeric value of alpha parameter in the model. alpha =
0 for Exchangeable Effects (EE), alpha = 1 for Exchangeable
Z-scores (EZ). Default is 0. Please refer to equation (3.2) of
M. Stephens 2016, Biostatistics for a discussion on alpha.}

\item{df}{An N by R matrix of corresponding degrees of freedom of
the t-statistic Bhat/Shat. Can be a scalar if all degrees of
freedom are equal. Default is inf (for large samples).}

\item{pval}{An N by R matrix of p-values of t-statistic
Bhat/Shat. Shat and df should not be specified when pval is
provided.}

\item{V}{an R by R matrix / [R x R x J] array of effect specific
correlation matrix of error correlations; must be positive
definite. [So Bhat_j distributed as N(B_j,diag(Shat_j) V_j
diag(Shat_j)) where _j denotes the jth row of a matrix]. Defaults
to identity.}

\item{zero_check_tol}{a small positive number as threshold for Shat
to be considered zero if any Shat is smaller or equal to this
number.}

\item{zero_Bhat_Shat_reset}{Replace zeros in Shat matrix to given
value if the corresponding Bhat are also zeros.}

\item{zero_Shat_reset}{Replace zeros in Shat matrix to given value.}
}
\value{
A data object for passing into mash functions.
}
\description{
Create a data object for mash analysis.
}
\examples{
simdata = simple_sims(50,5,1)
data = mash_set_data(simdata$Bhat, simdata$Shat)

}
