% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handlers.R
\name{handlers}
\alias{handlers}
\alias{has_warning}
\alias{has_error}
\alias{has_message}
\alias{get_warning}
\alias{get_message}
\alias{get_error}
\title{Handlers}
\usage{
has_warning(x, FUN, ...)

has_error(x, FUN, ...)

has_message(x, FUN, ...)

get_warning(x, FUN, ..., .null = TRUE)

get_message(x, FUN, ..., .null = TRUE)

get_error(x, FUN, ..., .null = TRUE)
}
\arguments{
\item{x}{A vector}

\item{FUN}{A function}

\item{...}{Additional params passed to \code{FUN}}

\item{.null}{Logical, if \code{FALSE} will drop \code{NULL} results (for \verb{get_*()})}
}
\value{
The \verb{has_*()} functions will return \code{TRUE}/\code{FALSE} for if the handler is
found in the execution of the code.
The \verb{get_*()} functions provide the text of the message
}
\description{
Catch and report handlers
}
\details{
These functions can be used to catch whether an evaluation will return an
error or warning without raising.
}
\examples{
has_warning(c(1, "no"), as.integer)
#     1    no
# FALSE  TRUE

get_warning(c(1, "no"), as.integer)

# drop NULLs
get_warning(c(1, "no"), as.integer, .null = FALSE)

foo <- function(x) {
  stopifnot(x > 0)
  x
}

has_error(c(1, 0, 2), foo)
#     1     0     2
# FALSE  TRUE FALSE

get_error(c(1, 0, 2), foo)

# drop NULLs
get_error(c(1, 0, 2), foo, .null = FALSE)
}
\references{
Function for \emph{catching} has been adapted from https://stackoverflow.com/a/4952908/12126576
}
