% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand.R
\name{reindex}
\alias{reindex}
\title{Reindex a data.frame}
\usage{
reindex(
  x,
  index = NULL,
  new_index,
  expand = c("intersect", "both"),
  sort = FALSE
)
}
\arguments{
\item{x}{A data.frame}

\item{index}{The column name or number of an index to use; if \code{NULL} will assume the
first column; a value of \code{row.names} will use \code{row.names(x)}}

\item{new_index}{A column vector of the new index value}

\item{expand}{Character switch to expand or keep only the values that
intersect (none), all values in x or index, or retain all values found.}

\item{sort}{Logical, if \code{TRUE} will sort the rows in output}
}
\value{
A \code{data.frame} with rows of \code{index}
}
\description{
Reindexes a data.frame with a reference
}
\examples{
iris1 <- head(iris, 5)
iris1$index <- 1:5
reindex(iris1, "index", seq(2, 8, 2))
reindex(iris1, "index", seq(2, 8, 2), expand = "both")

# Using letters will show changes in rownames
iris1$index <- letters[1:5]
reindex(iris1, "index", letters[seq(2, 8, 2)])
reindex(iris1, "index", seq(2, 8, 2))
reindex(iris1, "index", seq(2, 8, 2), expand = "both")
}
