% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kemptonQ.R
\name{kemptonQ}
\alias{kemptonQ}
\title{Calculates Kempton's Biodiversity Index}
\usage{
kemptonQ(X, TL.table, percentiles = c(0.25, 0.75), minTL = 0, groups,
  species.table = NULL, metric = "ABUNDANCE", years)
}
\arguments{
\item{X}{A dataframe of fishery independent data derived from research vessel
survey data or model output, with columns \code{YEAR}, \code{ID},
\code{SPECIES}, and \code{ABUNDANCE}. \code{YEAR} indicates the year the
observation was recorded, \code{ID} is an area code indicating where the
observation was recorded, \code{SPECIES} is a numeric code indicating the
species sampled, and \code{ABUNDANCE} is the corresponding abundance
(stratified and corrected for catchability as required).}

\item{TL.table}{A dataframe with columns \code{SPECIES} and the corresponding
\code{TL} (trophic level). Entries in the \code{SPECIES} column should be
the unique values of species codes in \code{X} (or a subset thereof). Other
columns in \code{TL.table} are ignored.}

\item{percentiles}{The percentiles used to determine R1 and R2. Default is
\code{percentiles = c(0.25, 0.75)}.}

\item{minTL}{Minimum trophic level for species included in the calculation.
Default is \code{minTL = 0}.}

\item{groups}{A vector indicating the species group(s) for which to calculate
the indicator. If \code{groups = "ALL"}, all species will be included;
otherwise, each entry must be a character string matching the name of a
column in \code{species.table}.}

\item{species.table}{A table where the column names match the entries in
\code{groups}. Column entries are species codes indicating the species from
\code{X} included in each group. \code{species.table} may also include
columns for other species groups; these will be ignored. If \code{groups =
"ALL"}, this table is not required. Default is \code{species.table = NULL}.}

\item{metric}{A character string indicating which column in \code{X} to use to
calculate the indicator. Default is \code{metric = "ABUNDANCE"}.}

\item{years}{A vector of years for which to calculate indicator.}
}
\value{
Returns a dataframe with columns \code{ID} and \code{YEAR}, and a
 column \code{KemptonQ_minTL_group} for each entry in \code{groups}.

 If there is no data for spatial scale \eqn{j} in year \eqn{i}, indicator
 values is assigned \code{NA}.
}
\description{
This function calculates Kempton's Biodiversity index (Q) for
 \eqn{j} areas and \eqn{i} years.
}
\details{
Kempton's Biodiversity Index \eqn{(Q)} is a relative index of
 diversity calculated from the Kempton's Q75 index developed for expressing
 species diversity. \deqn{Q = S*(p_2 - p_1)*log(R_2/R_1)} \eqn{S} is the
 total number of species or functional groups, \eqn{p_1} and  \eqn{p_2} are
 the lower and upper percentiles of interest and \eqn{R_1} and \eqn{R_2} are
 the corresponding lower and upper quartiles of the species abundance
 distribution. \eqn{p_1} and \eqn{p_2} are defaulted to 0.25 and 0.75,
 respectively (Kempton and Taylor, 1976).
}
\examples{
# Compile data
data(X)
data(species.info)

# Calculate indicator
kemptonQ(X, TL.table = species.info, percentiles = c(.25, 0.75), minTL = 0,
   groups = "ALL", metric = "ABUNDANCE", years = c(2014:2019))
}
\references{
Ainsworth, C, Pitcher, T. 2006. Modifying Kempton's species
 diversity index for use with ecosystem simulation models. Ecological
 Indicators. 6. 623-630. 10.1016/j.ecolind.2005.08.024.

 Bundy A, Gomez C, Cook AM. 2017. Guidance framework for the selection and
 evaluation of ecological indicators. Can. Tech. Rep. Fish. Aquat. Sci. 3232:
 xii + 212 p.

 Kempton R, Taylor L. 1976. Models and statistics for species diversity.
 Nature 262:818-820
}
\seealso{
Other biodiversity indicators: \code{\link{allBiodiversity}},
  \code{\link{heips}}, \code{\link{hillN1}},
  \code{\link{hillN2}}, \code{\link{margalef}},
  \code{\link{pielouEvenness}}, \code{\link{shannon}},
  \code{\link{speciesRichness}}
}
\author{
Danielle Dempsey \email{Danielle.Dempsey@dfo-mpo.gc.ca}, Adam Cook,
 Catalina Gomez, Alida Bundy
}
\concept{biodiversity indicators}
