% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marima.sim.R
\name{marima.sim}
\alias{marima.sim}
\title{marima.sim}
\usage{
marima.sim(kvar = 1, ar.model = NULL, ar.dif = NULL, ma.model = NULL,
  averages = rep(0, kvar), resid.cov = diag(kvar), seed = 4711,
  nstart = 0, nsim = 0)
}
\arguments{
\item{kvar}{dimension of one observation (from
kvar variate time series).}

\item{ar.model}{array holding the autoregressive part of model,
organised as in the marima$ar.estimates. May be
empty (default = NULL) when there is no autoregressive part.}

\item{ar.dif}{array holding differencing polynomium of model,
typically generated when applying the function define.dif. May be
empty (default = NULL) when differencing is not included.}

\item{ma.model}{array holding the moving average part of model,
organised as in the marima$ma.estimates. May be
empty (default = NULL) when there is no is no moving
average part.}

\item{averages}{vector holding the kvar averages of the
variables in the simulated series.}

\item{resid.cov}{(kvar x kvar) innovation covariance matrix.}

\item{seed}{seed for random number generator (set.seed(seed)).}

\item{nstart}{number of extra observations in the start of the
simulated series to be left out before returning. If nstart=0
in calling marima.sim a suitable value is computed (see code).}

\item{nsim}{length of (final) simulated series.}
}
\value{
Simulated kvar variate time series of length = nsim.
}
\description{
Simulation of multivariate arma model of
type 'marima'.
}
\examples{

library(marima)
data(austr)
old.data <- t(austr)[, 1:83]
Model2   <- define.model(kvar=7, ar=c(1), ma=c(1), rem.var=c(1,6,7),
indep=NULL)
Marima2  <- marima(old.data, means=1, ar.pattern=Model2$ar.pattern, 
 ma.pattern=Model2$ma.pattern, Check=FALSE, Plot="none", penalty=4)

resid.cov  <- Marima2$resid.cov
averages   <- Marima2$averages
        ar <- Marima2$ar.estimates
        ma <- Marima2$ma.estimates

N    <- 1000
kvar <- 7

y.sim <- marima.sim(kvar = kvar, ar.model = ar, ma.model = ma,
  seed = 4711, averages = averages, resid.cov = resid.cov, nsim = N)

# Now simulate from model identified by marima (model=Marima2).
# The relevant ar and ma patterns are saved in 
# Marima2$out.ar.pattern and Marima2$out.ma.pattern, respectively: 

Marima.sim <- marima( t(y.sim), means=1,
     ar.pattern=Marima2$out.ar.pattern, 
     ma.pattern=Marima2$out.ma.pattern,
     Check=FALSE, Plot="none", penalty=0) 

cat("Comparison of simulation model and estimates",
" from simulated data. \\n")
   round(Marima2$ar.estimates[,,2],4)
round(Marima.sim$ar.estimates[,,2],4)

   round(Marima2$ma.estimates[,,2],4)
round(Marima.sim$ma.estimates[,,2],4)

}

