% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginaleffects.R
\name{meffects}
\alias{meffects}
\title{\code{meffects()} is a shortcut to \code{marginaleffects()}}
\usage{
meffects(
  model,
  newdata = NULL,
  variables = NULL,
  vcov = TRUE,
  type = "response",
  ...
)
}
\arguments{
\item{model}{Model object}

\item{newdata}{A dataset over which to compute marginal effects. \code{NULL} uses
the original data used to fit the model.}

\item{variables}{Variables to consider (character vector). \code{NULL}
calculates marginal effects for all terms in the model object.}

\item{vcov}{Matrix or boolean
\itemize{
\item FALSE: does not compute unit-level standard errors.
\item TRUE: computes unit-level standard errors using the default \code{vcov(model)} variance-covariance matrix.
\item Named square matrix: computes standard errors with a user-supplied variance-covariance matrix. This matrix must be square and have dimensions equal to the number of coefficients in \code{get_coef(model)}.
}}

\item{type}{Type(s) of prediction as string or vector This can
differ based on the model type, but will typically be a string such as:
"response", "link", "probs", or "zero".}

\item{...}{Additional arguments are pushed forward to \code{predict()}.}
}
\value{
A \code{data.frame} with one row per observation (per term/group) and several columns:
\itemize{
\item \code{rowid}: row number of the \code{newdata} data frame
\item \code{type}: prediction type, as defined by the \code{type} argument
\item \code{group}: (optional) value of the grouped outcome (e.g., categorical outcome models)
\item \code{term}: the variable whose marginal effect is computed
\item \code{dydx}: marginal effect of the term on the outcome for a given combination of regressor values
\item \code{std.error}: standard errors computed by via the delta method.
}
}
\description{
A "marginal effect" is the partial derivative of the regression equation
with respect to a variable in the model. This function uses automatic
differentiation to compute marginal effects for a vast array of models,
including non-linear models with transformations (e.g., polynomials). The
list of supported models and of models whose numerical results have been
validated against external software (\code{Stata}, \code{margins}, and/or \code{emmeans})
is reported on the package website:
https://vincentarelbundock.github.io/marginaleffects/
}
\examples{

mod <- glm(am ~ hp * wt, data = mtcars, family = binomial)
mfx <- marginaleffects(mod)
summary(mfx)
tidy(mfx)
head(mfx)
plot(mfx)

# typical marginal effects
marginaleffects(mod, newdata = datagrid(hp = c(100, 110)))

# counterfactual average marginal effects
marginaleffects(mod, newdata = datagrid(hp = c(100, 110), grid.type = "counterfactual"))

# heteroskedasticity robust standard errors
marginaleffects(mod, vcov = sandwich::vcovHC(mod))

}
\keyword{internal}
