% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_label.R
\name{mf_label}
\alias{mf_label}
\title{Plot labels}
\usage{
mf_label(
  x,
  var,
  col,
  cex = 0.7,
  overlap = TRUE,
  lines = TRUE,
  halo = FALSE,
  bg,
  r = 0.1,
  ...
)
}
\arguments{
\item{x}{object of class \code{sf}}

\item{var}{name(s) of the variable(s) to plot}

\item{col}{labels color}

\item{cex}{labels cex}

\item{overlap}{if FALSE, labels are moved so they do not overlap.}

\item{lines}{if TRUE, then lines are plotted between x,y and the word,
for those words not covering their x,y coordinate}

\item{halo}{if TRUE, a 'halo' is displayed around the text and additional
arguments bg and r can be modified to set the color and width of the halo.}

\item{bg}{halo color}

\item{r}{width of the halo}

\item{...}{further \link{text} arguments.}
}
\value{
No return value, labels are displayed.
}
\description{
Put labels on a map.
}
\examples{
mtq <- mf_get_mtq()
mf_map(mtq)
mf_label(
  x = mtq, var = "LIBGEO", halo = TRUE, cex = 0.8,
  overlap = FALSE, lines = FALSE
)
}
