% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_mapmixture.R
\name{calc_default_bbox}
\alias{calc_default_bbox}
\title{Calculate Default Bounding Box}
\usage{
calc_default_bbox(data, expand = NULL)
}
\arguments{
\item{data}{data.frame or tibble containing three columns.
1st column is a character vector of site names.
2nd column is a numeric vector of latitude values.
3rd column is a numeric vector of longitude values.}

\item{expand}{numeric value indicating how much \% to increase the coordinates limits.}
}
\value{
A bbox object.
}
\description{
Internal function to calculate a default bounding box for a set of longitude and latitude coordinates.
}
\examples{
coords <- data.frame(
  site = c("Site1","Site2","Site3"),
  lat = c(40.0, 50.5, 60.5),
  lon = c(-1.0, 5.0, 10.5)
)
calc_default_bbox(coords, expand = NULL)
calc_default_bbox(coords, expand = 0.10)
}
\keyword{internal}
