% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_landcover.R
\docType{data}
\name{landcover}
\alias{landcover}
\title{Calculate area of different landcover classes}
\format{
A tibble with a column for area (in ha) per landcover class
}
\description{
The land cover data shows us how much of the region is covered by forests,
rivers, wetlands, barren land, or urban infrastructure thus allowing the
observation of land cover dynamics over a period of time. This function
allows to efficiently calculate area of different landcover classes for
polygons. For each polygon, the area of the classes in hectare(ha) is
returned.
The required resources for this indicator are:
\itemize{
\item \link{esalandcover}
}
}
\examples{
library(sf)
library(mapme.biodiversity)
(aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg", package = "mapme.biodiversity") \%>\%
  read_sf() \%>\%
  init_portfolio(
    years = 2016:2017,
    outdir = system.file("res", package = "mapme.biodiversity"),
    tmpdir = system.file("tmp", package = "mapme.biodiversity"),
    add_resources = FALSE,
    cores = 1,
    verbose = FALSE
  ) \%>\%
  get_resources("esalandcover") \%>\%
  calc_indicators("landcover") \%>\%
  tidyr::unnest(landcover))
}
\keyword{indicator}
