% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_props_stacked.R
\name{plot_props_stacked}
\alias{plot_props_stacked}
\title{Plot stacked bar charts of cell types proportions}
\usage{
plot_props_stacked(fit, group)
}
\arguments{
\item{fit}{A list returned by fit_maple()}

\item{group}{A column name of fit$W or a grouping vector of length N (nrow(fit$W))}
}
\value{
A ggplot object
}
\description{
This function allows you to visualize the relative abundance of sub-populations after running fit_maple()
}
\examples{
\dontrun{
brain1 <- LoadData("stxBrain", type = "anterior1")
brain2 <- LoadData("stxBrain", type = "anterior2")
brain1 <- SCTransform(brain1, assay = "Spatial", verbose = FALSE)
brain2 <- SCTransform(brain2, assay = "Spatial", verbose = FALSE)
brain <- merge(brain1,brain2)
DefaultAssay(brain) <- "SCT"
VariableFeatures(brain) <- c(VariableFeatures(brain1),VariableFeatures(brain2))
brain <- RunPCA(brain)
brain_fit_PCs <- fit_maple(brain,K = 6,emb = "PCs")
plot_props_stacked(brain_fit_PCs, group = brain$orig.ident)
}
}
\keyword{Bayesian}
\keyword{spatial}
\keyword{transcriptomics}
