% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/navigation.R
\name{mb_isochrone}
\alias{mb_isochrone}
\title{Generate an isochrone using the Mapbox API}
\usage{
mb_isochrone(
  location,
  profile = "driving",
  time = c(5, 10, 15),
  access_token = NULL,
  denoise = 1,
  geometry = "polygon",
  output = "sf",
  rate_limit = 300,
  keep_color_cols = FALSE,
  id_column = NULL
)
}
\arguments{
\item{location}{A vector of form \code{c(longitude, latitude)}, an address that can be geocoded as a character string, or an sf object.}

\item{profile}{One of "driving", "walking", or "cycling".  "driving" is the default.}

\item{time}{A vector of isochrone contours, specified in minutes. Defaults to \code{c(5, 10, 15)}.  The maximum time supported is 60 minutes.}

\item{access_token}{A valid Mapbox access token.}

\item{denoise}{A floating-point value between 0 and 1 used to remove smaller contours.  1 is the default and returns only the largest contour for an input time.}

\item{geometry}{one of \code{"polygon"} (the default), which returns isochrones as polygons, or alternatively \code{"linestring"}, which returns isochrones as linestrings.}

\item{output}{one of \code{"sf"} (the default), which returns an sf object representing the isochrone(s), or \code{"list"}, which returns the GeoJSON response from the API as an R list.}

\item{rate_limit}{The rate limit for the API, expressed in maximum number of calls per minute.  For most users this will be 300 though this parameter can be modified based on your Mapbox plan. Used when \code{location} is \code{"sf"}.}

\item{keep_color_cols}{Whether or not to retain the color columns that the Mapbox API generates by default (applies when the output is an sf object).  Defaults to \code{FALSE}.}

\item{id_column}{If the input dataset is an sf object, the column in your dataset you want to use as the isochrone ID.  Otherwise, isochrone IDs will be identified by row index or position.}
}
\value{
An sf object representing the isochrone(s) around the location(s).
}
\description{
Generate an isochrone using the Mapbox API
}
\examples{
\dontrun{

library(mapboxapi)
library(mapdeck)
isochrones <- mb_isochrone("The Kremlin, Moscow Russia",
                           time = c(4, 8, 12),
                           profile = "walking")

mapdeck(style = mapdeck_style("light")) \%>\%
  add_polygon(data = isochrones,
              fill_colour = "time",
              fill_opacity = 0.5,
              legend = TRUE)

}

}
