% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motif_census.R
\name{motif_net}
\alias{motif_net}
\alias{net_by_dyad}
\alias{net_by_triad}
\alias{net_by_mixed}
\title{Motifs at the network level}
\source{
Alejandro Espinosa 'netmem'
}
\usage{
net_by_dyad(.data)

net_by_triad(.data)

net_by_mixed(.data, object2)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{object2}{A second, two-mode migraph-consistent object.}
}
\description{
These functions include ways to take a census of the positions of nodes
in a network:
\itemize{
\item \code{net_by_dyad()} returns a census of dyad motifs in a network.
\item \code{net_by_triad()} returns a census of triad motifs in a network.
\item \code{net_by_mixed()} returns a census of triad motifs that span
a one-mode and a two-mode network.
}
}
\examples{
net_by_dyad(manynet::ison_algebra)
net_by_triad(manynet::ison_adolescents)
marvel_friends <- to_unsigned(ison_marvel_relationships, "positive")
(mixed_cen <- net_by_mixed(marvel_friends, ison_marvel_teams))
}
\references{
Davis, James A., and Samuel Leinhardt. 1967.
“\href{https://files.eric.ed.gov/fulltext/ED024086.pdf}{The Structure of Positive Interpersonal Relations in Small Groups}.” 55.

Hollway, James, Alessandro Lomi, Francesca Pallotti, and Christoph Stadtfeld. 2017.
“Multilevel Social Spaces: The Network Dynamics of Organizational Fields.”
\emph{Network Science} 5(2): 187–212.
\doi{10.1017/nws.2017.8}
}
\seealso{
Other motifs: 
\code{\link{motif_brokerage}},
\code{\link{motif_diffusion}},
\code{\link{motif_node}}
}
\concept{motifs}
